/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./public/messages.js":
/*!****************************!*\
  !*** ./public/messages.js ***!
  \****************************/
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function (root, factory) {
  "use strict";

  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(this, function () {
  "use strict";

  function inferLocale() {
    if (typeof document !== "undefined" && document.documentElement) {
      return document.documentElement.lang;
    }
  }
  function convertNumber(str) {
    if (str === "-Inf") {
      return -Infinity;
    } else if (str === "+Inf" || str === "Inf" || str === "*") {
      return Infinity;
    }
    return parseInt(str, 10);
  }
  var intervalRegexp = /^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;
  var anyIntervalRegexp = /({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;
  var defaults = {
    locale: "en"
  };
  var Lang = function Lang(options) {
    options = options || {};
    this.locale = options.locale || inferLocale() || defaults.locale;
    this.fallback = options.fallback;
    this.messages = options.messages;
  };
  Lang.prototype.setMessages = function (messages) {
    this.messages = messages;
  };
  Lang.prototype.getLocale = function () {
    return this.locale || this.fallback;
  };
  Lang.prototype.setLocale = function (locale) {
    this.locale = locale;
  };
  Lang.prototype.getFallback = function () {
    return this.fallback;
  };
  Lang.prototype.setFallback = function (fallback) {
    this.fallback = fallback;
  };
  Lang.prototype.has = function (key, locale) {
    if (typeof key !== "string" || !this.messages) {
      return false;
    }
    return this._getMessage(key, locale) !== null;
  };
  Lang.prototype.get = function (key, replacements, locale) {
    if (!this.has(key, locale)) {
      return key;
    }
    var message = this._getMessage(key, locale);
    if (message === null) {
      return key;
    }
    if (replacements) {
      message = this._applyReplacements(message, replacements);
    }
    return message;
  };
  Lang.prototype.trans = function (key, replacements) {
    return this.get(key, replacements);
  };
  Lang.prototype.choice = function (key, number, replacements, locale) {
    replacements = typeof replacements !== "undefined" ? replacements : {};
    replacements.count = number;
    var message = this.get(key, replacements, locale);
    if (message === null || message === undefined) {
      return message;
    }
    var messageParts = message.split("|");
    var explicitRules = [];
    for (var i = 0; i < messageParts.length; i++) {
      messageParts[i] = messageParts[i].trim();
      if (anyIntervalRegexp.test(messageParts[i])) {
        var messageSpaceSplit = messageParts[i].split(/\s/);
        explicitRules.push(messageSpaceSplit.shift());
        messageParts[i] = messageSpaceSplit.join(" ");
      }
    }
    if (messageParts.length === 1) {
      return message;
    }
    for (var j = 0; j < explicitRules.length; j++) {
      if (this._testInterval(number, explicitRules[j])) {
        return messageParts[j];
      }
    }
    var pluralForm = this._getPluralForm(number);
    return messageParts[pluralForm];
  };
  Lang.prototype.transChoice = function (key, count, replacements) {
    return this.choice(key, count, replacements);
  };
  Lang.prototype._parseKey = function (key, locale) {
    if (typeof key !== "string" || typeof locale !== "string") {
      return null;
    }
    var segments = key.split(".");
    var source = segments[0].replace(/\//g, ".");
    return {
      source: locale + "." + source,
      sourceFallback: this.getFallback() + "." + source,
      entries: segments.slice(1)
    };
  };
  Lang.prototype._getMessage = function (key, locale) {
    locale = locale || this.getLocale();
    key = this._parseKey(key, locale);
    if (this.messages[key.source] === undefined && this.messages[key.sourceFallback] === undefined) {
      return null;
    }
    var message = this.messages[key.source];
    var entries = key.entries.slice();
    var subKey = "";
    while (entries.length && message !== undefined) {
      var subKey = !subKey ? entries.shift() : subKey.concat(".", entries.shift());
      if (message[subKey] !== undefined) {
        message = message[subKey];
        subKey = "";
      }
    }
    if (typeof message !== "string" && this.messages[key.sourceFallback]) {
      message = this.messages[key.sourceFallback];
      entries = key.entries.slice();
      subKey = "";
      while (entries.length && message !== undefined) {
        var subKey = !subKey ? entries.shift() : subKey.concat(".", entries.shift());
        if (message[subKey]) {
          message = message[subKey];
          subKey = "";
        }
      }
    }
    if (typeof message !== "string") {
      return null;
    }
    return message;
  };
  Lang.prototype._findMessageInTree = function (pathSegments, tree) {
    while (pathSegments.length && tree !== undefined) {
      var dottedKey = pathSegments.join(".");
      if (tree[dottedKey]) {
        tree = tree[dottedKey];
        break;
      }
      tree = tree[pathSegments.shift()];
    }
    return tree;
  };
  Lang.prototype._applyReplacements = function (message, replacements) {
    for (var replace in replacements) {
      message = message.replace(new RegExp(":" + replace, "gi"), function (match) {
        var value = replacements[replace];
        var allCaps = match === match.toUpperCase();
        if (allCaps) {
          return value.toUpperCase();
        }
        var firstCap = match === match.replace(/\w/i, function (letter) {
          return letter.toUpperCase();
        });
        if (firstCap) {
          return value.charAt(0).toUpperCase() + value.slice(1);
        }
        return value;
      });
    }
    return message;
  };
  Lang.prototype._testInterval = function (count, interval) {
    if (typeof interval !== "string") {
      throw "Invalid interval: should be a string.";
    }
    interval = interval.trim();
    var matches = interval.match(intervalRegexp);
    if (!matches) {
      throw "Invalid interval: " + interval;
    }
    if (matches[2]) {
      var items = matches[2].split(",");
      for (var i = 0; i < items.length; i++) {
        if (parseInt(items[i], 10) === count) {
          return true;
        }
      }
    } else {
      matches = matches.filter(function (match) {
        return !!match;
      });
      var leftDelimiter = matches[1];
      var leftNumber = convertNumber(matches[2]);
      if (leftNumber === Infinity) {
        leftNumber = -Infinity;
      }
      var rightNumber = convertNumber(matches[3]);
      var rightDelimiter = matches[4];
      return (leftDelimiter === "[" ? count >= leftNumber : count > leftNumber) && (rightDelimiter === "]" ? count <= rightNumber : count < rightNumber);
    }
    return false;
  };
  Lang.prototype._getPluralForm = function (count) {
    switch (this.locale) {
      case "az":
      case "bo":
      case "dz":
      case "id":
      case "ja":
      case "jv":
      case "ka":
      case "km":
      case "kn":
      case "ko":
      case "ms":
      case "th":
      case "tr":
      case "vi":
      case "zh":
        return 0;
      case "af":
      case "bn":
      case "bg":
      case "ca":
      case "da":
      case "de":
      case "el":
      case "en":
      case "eo":
      case "es":
      case "et":
      case "eu":
      case "fa":
      case "fi":
      case "fo":
      case "fur":
      case "fy":
      case "gl":
      case "gu":
      case "ha":
      case "he":
      case "hu":
      case "is":
      case "it":
      case "ku":
      case "lb":
      case "ml":
      case "mn":
      case "mr":
      case "nah":
      case "nb":
      case "ne":
      case "nl":
      case "nn":
      case "no":
      case "om":
      case "or":
      case "pa":
      case "pap":
      case "ps":
      case "pt":
      case "so":
      case "sq":
      case "sv":
      case "sw":
      case "ta":
      case "te":
      case "tk":
      case "ur":
      case "zu":
        return count == 1 ? 0 : 1;
      case "am":
      case "bh":
      case "fil":
      case "fr":
      case "gun":
      case "hi":
      case "hy":
      case "ln":
      case "mg":
      case "nso":
      case "xbr":
      case "ti":
      case "wa":
        return count === 0 || count === 1 ? 0 : 1;
      case "be":
      case "bs":
      case "hr":
      case "ru":
      case "sr":
      case "uk":
        return count % 10 == 1 && count % 100 != 11 ? 0 : count % 10 >= 2 && count % 10 <= 4 && (count % 100 < 10 || count % 100 >= 20) ? 1 : 2;
      case "cs":
      case "sk":
        return count == 1 ? 0 : count >= 2 && count <= 4 ? 1 : 2;
      case "ga":
        return count == 1 ? 0 : count == 2 ? 1 : 2;
      case "lt":
        return count % 10 == 1 && count % 100 != 11 ? 0 : count % 10 >= 2 && (count % 100 < 10 || count % 100 >= 20) ? 1 : 2;
      case "sl":
        return count % 100 == 1 ? 0 : count % 100 == 2 ? 1 : count % 100 == 3 || count % 100 == 4 ? 2 : 3;
      case "mk":
        return count % 10 == 1 ? 0 : 1;
      case "mt":
        return count == 1 ? 0 : count === 0 || count % 100 > 1 && count % 100 < 11 ? 1 : count % 100 > 10 && count % 100 < 20 ? 2 : 3;
      case "lv":
        return count === 0 ? 0 : count % 10 == 1 && count % 100 != 11 ? 1 : 2;
      case "pl":
        return count == 1 ? 0 : count % 10 >= 2 && count % 10 <= 4 && (count % 100 < 12 || count % 100 > 14) ? 1 : 2;
      case "cy":
        return count == 1 ? 0 : count == 2 ? 1 : count == 8 || count == 11 ? 2 : 3;
      case "ro":
        return count == 1 ? 0 : count === 0 || count % 100 > 0 && count % 100 < 20 ? 1 : 2;
      case "ar":
        return count === 0 ? 0 : count == 1 ? 1 : count == 2 ? 2 : count % 100 >= 3 && count % 100 <= 10 ? 3 : count % 100 >= 11 && count % 100 <= 99 ? 4 : 5;
      default:
        return 0;
    }
  };
  return Lang;
});
(function () {
  Lang = new Lang();
  Lang.setMessages({
    "ar.js": {
      "Yes_Change": "\u0646\u0639\u0645\u060C \u0642\u0628\u0648\u0644",
      "add_on": "\u0625\u0636\u0627\u0641\u0629 \u0639\u0644\u0649",
      "address_field": "\u062D\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u062D\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.",
      "admin": "\u0627\u0644\u0645\u0634\u0631\u0641",
      "affiliation_amount_error": "\u0644\u0627 \u064A\u0645\u0643\u0646 \u062A\u062C\u0627\u0648\u0632 \u0645\u0628\u0644\u063A \u0627\u0644\u0627\u0646\u062A\u0645\u0627\u0621 100\u066A",
      "affiliation_email_send": "\u062A\u0645 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0625\u0644\u0643\u062A\u0631\u0648\u0646\u064A \u0644\u0644\u062F\u0639\u0648\u0629 \u0628\u0646\u062C\u0627\u062D!",
      "agree_term": "\u064A\u062C\u0628 \u0623\u0646 \u062A\u0648\u0627\u0641\u0642 \u0639\u0644\u0649 \u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062D\u0643\u0627\u0645.",
      "allowed_file_types": "\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062A \u0627\u0644\u0645\u0633\u0645\u0648\u062D \u0628\u0647\u0627: png\u060C jpg\u060C jpeg.",
      "allowed_image": "\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062A \u0627\u0644\u0645\u0633\u0645\u0648\u062D \u0628\u0647\u0627: png\u060C jpg\u060C jpeg.",
      "amount": "\u0627\u0644\u0645\u0628\u0644\u063A",
      "app_name_required": "\u062D\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u062A\u0637\u0628\u064A\u0642 \u0645\u0637\u0644\u0648\u0628",
      "apply": "\u062A\u0642\u062F\u064A\u0645 \u0637\u0644\u0628",
      "appointment": "\u0627\u0644\u0645\u0648\u0639\u062F",
      "appointments": "\u0627\u0644\u0645\u0648\u0627\u0639\u064A\u062F",
      "approved": "\u0645\u0648\u0627\u0641\u0642 \u0639\u0644\u064A\u0647",
      "apr": "\u0625\u0628\u0631\u064A\u0644",
      "are_you_completed": "\u0647\u0644 \u0623\u0646\u062A \u0645\u062A\u0623\u0643\u062F \u0623\u0646\u0643 \u062A\u0631\u064A\u062F \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0647\u0630\u0627\u061F",
      "are_you_sure": "\u0647\u0644 \u0623\u0646\u062A \u0645\u062A\u0623\u0643\u062F \u0623\u0646\u0643 \u062A\u0631\u064A\u062F \u062D\u0630\u0641 \u0647\u0630\u0627",
      "are_you_sure_dublicate_vcard": "\u0647\u0644 \u0623\u0646\u062A \u0645\u062A\u0623\u0643\u062F \u0623\u0646\u0643 \u062A\u0631\u064A\u062F \u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062E\u0629 \u0645\u0643\u0631\u0631\u0629 \u0645\u0646 \u0647\u0630\u0647 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0634\u062E\u0635\u064A\u0629\u061F",
      "are_you_sure_want_to_delete_selected_Vcards": "\u0647\u0644 \u0623\u0646\u062A \u0645\u062A\u0623\u0643\u062F \u0623\u0646\u0643 \u062A\u0631\u064A\u062F \u062D\u0630\u0641 \"Vcards\" \u0627\u0644\u0645\u062D\u062F\u062F\u0629\u061F",
      "aug": "\u0623\u063A\u0633\u0637\u0633",
      "back_image_field_required": "\u062D\u0642\u0644 \u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u062E\u0644\u0641\u064A\u0629 \u0645\u0637\u0644\u0648\u0628",
      "blog": "\u0645\u062F\u0648\u0646\u0629",
      "blog_description": "\u0648\u0635\u0641",
      "blog_image_required": "\u062D\u0642\u0644 \u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u062F\u0648\u0646\u0629 \u0645\u0637\u0644\u0648\u0628.",
      "cancel": "\u0625\u0644\u063A\u0627\u0621",
      "check_email": "\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0627\u0644\u0643\u062A\u0631\u0648\u0646\u064A \u0645\u0648\u062C\u0648\u062F \u0628\u0627\u0644\u0641\u0639\u0644.",
      "choose_one_template": "\u0627\u062E\u062A\u0631 \u0623\u064A \u0642\u0627\u0644\u0628 \u0648\u0627\u062D\u062F",
      "choose_plan": "\u0627\u062E\u062A\u0631 \u0627\u0644\u062E\u0637\u0629",
      "city": "\u0627\u0644\u0645\u062F\u064A\u0646\u0629",
      "click_open_sidebar": "\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u062A\u0627\u0644\u064A \u0644\u0641\u062A\u062D \u0627\u0644\u0634\u0631\u064A\u0637 \u0627\u0644\u062C\u0627\u0646\u0628\u064A.",
      "click_to_add_vcard_name": "\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0625\u0636\u0627\u0641\u0629 \u0627\u0633\u0645 Vcard \u0627\u0644\u062E\u0627\u0635 \u0628\u0643.",
      "click_to_create_vcards": "\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u062A\u0627\u0644\u064A \u0644\u0625\u0646\u0634\u0627\u0621 VCard \u0627\u0644\u062E\u0627\u0635 \u0628\u0643.",
      "click_to_generate_alias": "\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062A\u0639\u0627\u0631 \u0644\u0639\u0646\u0648\u0627\u0646 URL \u0627\u0644\u062E\u0627\u0635 \u0628\u0643.",
      "click_to_go_dashboard": "\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \"\u0627\u0644\u062A\u0627\u0644\u064A\" \u0644\u0644\u0645\u062A\u0627\u0628\u0639\u0629 \u0625\u0644\u0649 \u0644\u0648\u062D\u0629 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062A.",
      "click_to_make_vcards": "\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \"\u0627\u0644\u062A\u0627\u0644\u064A\" \u0644\u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0627\u062A VCard \u062C\u062F\u064A\u062F\u0629.",
      "click_to_open_edit_sidebar": "\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \"\u0627\u0644\u062A\u0627\u0644\u064A\" \u0644\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0627\u0644\u0634\u0631\u064A\u0637 \u0627\u0644\u062C\u0627\u0646\u0628\u064A \u0644\u062A\u062D\u0631\u064A\u0631 VCard.",
      "click_to_preview": "\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0645\u0639\u0627\u064A\u0646\u0629 VCard \u0627\u0644\u062E\u0627\u0635 \u0628\u0643.",
      "click_to_save_vcard": "\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u062A\u0627\u0644\u064A \u0644\u062D\u0641\u0638 VCard \u0627\u0644\u062E\u0627\u0635 \u0628\u0643.",
      "completed": "\u062A\u0645 \u0627\u0644\u0627\u0646\u062A\u0647\u0627\u0621",
      "copied_successfully": "\u062A\u0645 \u0646\u0633\u062E \u0627\u0644\u0631\u0627\u0628\u0637 \u0628\u0646\u062C\u0627\u062D.",
      "country": "\u0627\u0644\u062F\u0648\u0644\u0629",
      "coupon_code": "\u0631\u0645\u0648\u0632 \u0627\u0644\u0642\u0633\u0627\u0626\u0645",
      "coupon_code_apply": "\u062A\u0645 \u062A\u0637\u0628\u064A\u0642 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064A\u0645\u0629 \u0628\u0646\u062C\u0627\u062D.",
      "coupon_code_percent_validation": "\u064A\u062C\u0628 \u0623\u0644\u0627 \u064A\u0643\u0648\u0646 \u062A\u062E\u0641\u064A\u0636 \u0627\u0644\u0642\u0633\u064A\u0645\u0629 \u0623\u0643\u062B\u0631 \u0645\u0646 100\u066A.",
      "custom": "\u0645\u062E\u0635\u0635",
      "custom_link": "\u0631\u0627\u0628\u0637 \u0645\u062E\u0635\u0635",
      "custom_vcard_number": "\u0631\u0642\u0645 \u0628\u0637\u0627\u0642\u0629 VCard \u0627\u0644\u0645\u062E\u0635\u0635\u0629",
      "custom_vcard_price": "\u0628\u0637\u0627\u0642\u0629 VCard \u0645\u062E\u0635\u0635\u0629 \u0628\u062F\u0648\u0646 \u0633\u0639\u0631",
      "dec": "\u062F\u064A\u0633\u0645\u0628\u0631",
      "delete": "\u062D\u0630\u0641",
      "deleted": "\u062A\u0645 \u0627\u0644\u062D\u0630\u0641",
      "description": "\u0623\u062F\u062E\u0644 \u0648\u0635\u0641 \u0628\u0637\u0627\u0642\u062A\u0643 \u0627\u0644\u0634\u062E\u0635\u064A\u0629",
      "description_length": "\u064A\u062C\u0628 \u0623\u0646 \u062A\u0643\u0648\u0646 \u0627\u0644\u0648\u0635\u0641 \u0644\u0627 \u064A\u0642\u0644 \u0639\u0646 3 \u0623\u062D\u0631\u0641.",
      "description_required": "\u062D\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0645\u0637\u0644\u0648\u0628.",
      "duplicate": "\u0645\u0643\u0631\u0631!",
      "duplicate_vcard": "\u0628\u0637\u0627\u0642\u0629 \u0634\u062E\u0635\u064A\u0629 \u0645\u0643\u0631\u0631\u0629!",
      "duplicate_vcard_create": "\u062A\u0645 \u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0629 \u0634\u062E\u0635\u064A\u0629 \u0645\u0643\u0631\u0631\u0629 \u0628\u0646\u062C\u0627\u062D",
      "email": "\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0625\u0644\u0643\u062A\u0631\u0648\u0646\u064A",
      "email_required": "\u062D\u0642\u0644 \u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0625\u0644\u0643\u062A\u0631\u0648\u0646\u064A \u0645\u0637\u0644\u0648\u0628",
      "embedtag": "\u062A\u0636\u0645\u064A\u0646 \u0627\u0644\u0639\u0644\u0627\u0645\u0629",
      "enquiry": "\u0627\u0633\u062A\u0641\u0633\u0627\u0631",
      "enter_valid_email": "\u0627\u0644\u0631\u062C\u0627\u0621 \u0625\u062F\u062E\u0627\u0644 \u0628\u0631\u064A\u062F \u0625\u0644\u0643\u062A\u0631\u0648\u0646\u064A \u0635\u0627\u0644\u062D.",
      "enter_vcard_name": "\u0627\u0644\u0631\u062C\u0627\u0621 \u0625\u062F\u062E\u0627\u0644 \u0627\u0633\u0645 Vcard",
      "error": "\u062E\u0637\u0623",
      "faqs": "\u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629",
      "feb": "\u0641\u0628\u0631\u0627\u064A\u0631",
      "first_name_required": "\u062D\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644 \u0645\u0637\u0644\u0648\u0628.",
      "flat": "\u0645\u0633\u062A\u0648\u0649",
      "flutterwave_key": "\u062D\u0642\u0644 \u0645\u0641\u062A\u0627\u062D Flutterwave \u0645\u0637\u0644\u0648\u0628.",
      "flutterwave_secret": "\u062D\u0642\u0644 \u0633\u0631 Flutterwave \u0645\u0637\u0644\u0648\u0628.",
      "fri": "\u0627\u0644\u062C\u0645\u0639\u0629",
      "from": "\u0645\u0646",
      "front_image_field_required": "\u062D\u0642\u0644 \u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064A\u0629 \u0645\u0637\u0644\u0648\u0628",
      "gallery": "\u0645\u0639\u0631\u0636 \u0627\u0644\u0635\u0648\u0631",
      "generate_url_alias": "\u0627\u0644\u0631\u062C\u0627\u0621 \u0625\u0646\u0634\u0627\u0621 \u0627\u0633\u0645 \u0645\u0633\u062A\u0639\u0627\u0631 \u0644\u0639\u0646\u0648\u0627\u0646 URL",
      "has_been_completed": "\u062A\u0645 \u0627\u0644\u0627\u0646\u062A\u0647\u0627\u0621.",
      "has_been_deleted": "\u062A\u0645 \u062D\u0630\u0641\u0647.",
      "here_select_vcard_template": "\u0647\u0646\u0627 \u064A\u0645\u0643\u0646\u0643 \u062A\u062D\u062F\u064A\u062F \u0642\u0627\u0644\u0628 VCard \u0627\u0644\u062E\u0627\u0635 \u0628\u0643.",
      "image_too_large": "\u0645\u0644\u0641\u0643 \u0643\u0628\u064A\u0631 \u062C\u062F\u064B\u0627. \u0627\u0644\u062D\u062F \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u0644\u062D\u062C\u0645 \u0627\u0644\u0645\u0633\u0645\u0648\u062D \u0628\u0647 \u0647\u0648 1 \u0645\u064A\u062C\u0627\u0628\u0627\u064A\u062A.",
      "in_progress": "\u0642\u064A\u062F \u0627\u0644\u062A\u0646\u0641\u064A\u0630",
      "inquries": "\u0633\u0624\u0627\u0644",
      "invalid_country_code": "\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062F \u063A\u064A\u0631 \u0635\u0627\u0644\u062D",
      "invalid_email": "\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0625\u0644\u0643\u062A\u0631\u0648\u0646\u064A \u063A\u064A\u0631 \u0635\u0627\u0644\u062D",
      "invalid_number": "\u0631\u0642\u0645 \u063A\u064A\u0631 \u0635\u0627\u0644\u062D",
      "jan": "\u064A\u0646\u0627\u064A\u0631",
      "jul": "\u064A\u0648\u0644\u064A\u0648",
      "jun": "\u064A\u0648\u0646\u064A\u0648",
      "last_30_days": "\u0627\u0644\u064030 \u064A\u0648\u0645 \u0627\u0644\u0623\u062E\u064A\u0631\u0629",
      "last_7_days": "\u0627\u0644\u0623\u064A\u0627\u0645 \u0627\u0644\u0633\u0628\u0639\u0629 \u0627\u0644\u0645\u0627\u0636\u064A\u0629",
      "last_name_required": "\u062D\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062E\u064A\u0631 \u0645\u0637\u0644\u0648\u0628.",
      "last_week": "\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064A",
      "loading": "\u062C\u0627\u0631 \u0627\u0644\u062A\u062D\u0645\u064A\u0644...",
      "location_field_required": "\u062D\u0642\u0644 \u0627\u0644\u0645\u0648\u0642\u0639 \u0645\u0637\u0644\u0648\u0628",
      "logo_field_required": "\u062D\u0642\u0644 \u0634\u0639\u0627\u0631 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0645\u0637\u0644\u0648\u0628",
      "logo_image_error": "\u064A\u062C\u0628 \u0623\u0646 \u062A\u0643\u0648\u0646 \u0623\u0628\u0639\u0627\u062F \u0627\u0644\u0635\u0648\u0631\u0629 150x150 \u0628\u0643\u0633\u0644 \u0623\u0648 \u0623\u0642\u0644.",
      "manual_payment_guide": "\u062F\u0644\u064A\u0644 \u0627\u0644\u062F\u0641\u0639 \u0627\u0644\u064A\u062F\u0648\u064A",
      "mar": "\u0645\u0627\u0631\u0633",
      "may": "\u0645\u0627\u064A\u0648",
      "mon": "\u0627\u0644\u0627\u062B\u0646\u064A\u0646",
      "month": "\u0627\u0644\u0634\u0647\u0631",
      "multi_templates": "\u0645\u0637\u0644\u0648\u0628 \u0642\u0648\u0627\u0644\u0628 \u0645\u062A\u0639\u062F\u062F\u0629",
      "next": "\u0627\u0644\u062A\u0627\u0644\u064A",
      "nfc_card": "\u0628\u0637\u0627\u0642\u0629 NFC",
      "nfc_order": "\u0637\u0644\u0628 NFC",
      "no": "\u0644\u0627",
      "nov": "\u0646\u0648\u0641\u0645\u0628\u0631",
      "occupation_field_required": "\u062D\u0642\u0644 \u0627\u0644\u0645\u0647\u0646\u0629 \u0645\u0637\u0644\u0648\u0628",
      "oct": "\u0623\u0643\u062A\u0648\u0628\u0631",
      "ok": "\u062D\u0633\u0646\u0627",
      "onesignal_app_id": "\u062D\u0642\u0644 \u0645\u0639\u0631\u0641 \u0627\u0644\u062A\u0637\u0628\u064A\u0642 \u0641\u064A OneSignal \u0645\u0637\u0644\u0648\u0628.",
      "onesignal_rest_api_key": "\u062D\u0642\u0644 \u0645\u0641\u062A\u0627\u062D \u0648\u0627\u062C\u0647\u0629 \u0628\u0631\u0645\u062C\u0629 \u0627\u0644\u062A\u0637\u0628\u064A\u0642\u0627\u062A \u0641\u064A OneSignal \u0645\u0637\u0644\u0648\u0628.",
      "order_placed": "\u062A\u0645 \u062A\u0642\u062F\u064A\u0645 \u0637\u0644\u0628\u0643 \u0628\u0646\u062C\u0627\u062D!",
      "password_character": "\u064A\u062C\u0628 \u0623\u0646 \u062A\u0643\u0648\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 8 \u0623\u062D",
      "password_must_match": "\u064A\u062C\u0628 \u0623\u0646 \u062A\u062A\u0637\u0627\u0628\u0642 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0639 \u062A\u0623\u0643\u064A\u062F \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631.",
      "passwords": "\u062D\u0642\u0644 \u0643\u0644\u0645\u0627\u062A \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0637\u0644\u0648\u0628.",
      "payment_not_complete": "\u0644\u0645 \u064A\u062A\u0645 \u0627\u0644\u0627\u0646\u062A\u0647\u0627\u0621 \u0645\u0646 \u0639\u0645\u0644\u064A\u0629 \u0627\u0644\u062F\u0641\u0639",
      "paypal_key": "\u062D\u0642\u0644 \u0645\u0639\u0631\u0641 \u0639\u0645\u064A\u0644 Paypal \u0645\u0637\u0644\u0648\u0628.",
      "paypal_mode": "\u062D\u0642\u0644 \u0648\u0636\u0639 Paypal \u0645\u0637\u0644\u0648\u0628.",
      "paypal_secret": "\u062D\u0642\u0644 \u0633\u0631 Paypal \u0645\u0637\u0644\u0648\u0628.",
      "paystack_key": "\u062D\u0642\u0644 \u0645\u0641\u062A\u0627\u062D Paystack \u0645\u0637\u0644\u0648\u0628.",
      "paystack_secret": "\u062D\u0642\u0644 \u0633\u0631 Paystack \u0645\u0637\u0644\u0648\u0628.",
      "phone": "\u0627\u0644\u0647\u0627\u062A\u0641",
      "phone_number_required": "\u062D\u0642\u0644 \u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062A\u0641 \u0645\u0637\u0644\u0648\u0628.",
      "phonepe_env_required": "\u062D\u0642\u0644 Phonepe Env \u0645\u0637\u0644\u0648\u0628.",
      "phonepe_merchant_id_required": "\u062D\u0642\u0644 \u0645\u0639\u0631\u0641 \u0627\u0644\u062A\u0627\u062C\u0631 Phonepe \u0645\u0637\u0644\u0648\u0628.",
      "phonepe_merchant_transaction_id_required": "\u062D\u0642\u0644 \u0645\u0639\u0631\u0641 \u0645\u0639\u0627\u0645\u0644\u0629 \u062A\u0627\u062C\u0631 Phonepe \u0645\u0637\u0644\u0648\u0628.",
      "phonepe_merchant_user_id_required": "\u062D\u0642\u0644 \u0645\u0639\u0631\u0641 \u0645\u0633\u062A\u062E\u062F\u0645 \u062A\u0627\u062C\u0631 Phonepe \u0645\u0637\u0644\u0648\u0628.",
      "phonepe_salt_index_required": "\u062D\u0642\u0644 \u0645\u0624\u0634\u0631 \u0645\u0644\u062D \u0627\u0644\u0647\u0627\u062A\u0641 \u0645\u0637\u0644\u0648\u0628.",
      "phonepe_salt_key_required": "\u062D\u0642\u0644 \u0645\u0641\u062A\u0627\u062D \u0645\u0644\u062D \u0627\u0644\u0647\u0627\u062A\u0641 \u0645\u0637\u0644\u0648\u0628.",
      "plan": "\u0627\u0644\u062E\u0637\u0629",
      "plan_expire_notification": "\u062D\u0642\u0644 \u0625\u0634\u0639\u0627\u0631 \u0627\u0646\u062A\u0647\u0627\u0621 \u0627\u0644\u062E\u0637\u0629 \u0645\u0637\u0644\u0648\u0628.",
      "please_select_user": "\u064A\u0631\u062C\u0649 \u0627\u062E\u062A\u064A\u0627\u0631 \u0645\u0633\u062A\u062E\u062F\u0645",
      "please_wait": "\u064A\u0631\u062C\u0649 \u0627\u0644\u0627\u0646\u062A\u0638\u0627\u0631...",
      "privacy_policy": "\u0633\u064A\u0627\u0633\u0629 \u0627\u0644\u062E\u0635\u0648\u0635\u064A\u0629",
      "product": "\u0645\u0646\u062A\u062C",
      "product_added_to_cart": "\u062A\u0645\u062A \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0646\u062A\u062C \u0625\u0644\u0649 \u0633\u0644\u0629 \u0627\u0644\u062A\u0633\u0648\u0642 \u0628\u0646\u062C\u0627\u062D!",
      "product_category": "\u0641\u0626\u0629 \u0627\u0644\u0645\u0646\u062A\u062C",
      "product_deleted_from_cart": "\u062A\u0645\u062A \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0646\u062A\u062C \u0645\u0646 \u0633\u0644\u0629 \u0627\u0644\u062A\u0633\u0648\u0642 \u0628\u0646\u062C\u0627\u062D!",
      "provide_valid_wbsite_url": "\u0623\u062F\u062E\u0644 \u0631\u0627\u0628\u0637 \u0635\u062D\u064A\u062D",
      "purchase": "\u0634\u0631\u0627\u0621",
      "razorpay_key": "\u062D\u0642\u0644 \u0645\u0641\u062A\u0627\u062D Rozorpay \u0645\u0637\u0644\u0648\u0628.",
      "razorpay_secret": "\u062D\u0642\u0644 Rozorpay Secret \u0645\u0637\u0644\u0648\u0628.",
      "rejected": "\u0645\u0631\u0641\u0648\u0636",
      "remove": "\u0625\u0632\u0627\u0644\u0629",
      "sat": "\u0627\u0644\u0633\u0628\u062A",
      "select_all": "\u062D\u062F\u062F \u0627\u0644\u0643\u0644",
      "select_email_required": "\u062D\u0642\u0644 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0628\u0631\u064A\u062F \u0645\u0637\u0644\u0648\u0628.",
      "select_hour": "\u064A\u0631\u062C\u0649 \u062A\u062D\u062F\u064A\u062F \u0627\u0644\u062A\u0627\u0631\u064A\u062E \u0623\u0648 \u0627\u0644\u0633\u0627\u0639\u0629",
      "select_one_or_more": "\u062D\u062F\u062F \u0648\u0627\u062D\u062F \u0623\u0648 \u0623\u0643\u062B\u0631",
      "select_payment_type": "\u0627\u062E\u062A\u0631 \u0637\u0631\u064A\u0642\u0629 \u0627\u0644\u062F\u0641\u0639",
      "select_user": "\u0627\u062E\u062A\u064A\u0627\u0631 \u0627\u0644\u0645\u0633\u062A\u062E\u062F\u0645",
      "select_vcard": "\u062D\u062F\u062F Vcard",
      "send_email_description": "\u0627\u0644\u0648\u0635\u0641",
      "sep": "\u0633\u0628\u062A\u0645\u0628\u0631",
      "short_description": "\u0623\u062F\u062E\u0644 \u0627\u0644\u0648\u0635\u0641 \u0627\u0644\u0642\u0635\u064A\u0631",
      "skip": "\u064A\u062A\u062E\u0637\u0649",
      "social_links_img_is_required": "\u0635\u0648\u0631\u0629 \u0631\u0648\u0627\u0628\u0637 \u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u062A\u0648\u0627\u0635\u0644 \u0627\u0644\u0627\u062C\u062A\u0645\u0627\u0639\u064A \u0645\u0637\u0644\u0648\u0628\u0629.",
      "social_links_is_required": "\u0631\u0648\u0627\u0628\u0637 \u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u062A\u0648\u0627\u0635\u0644 \u0627\u0644\u0627\u062C\u062A\u0645\u0627\u0639\u064A \u0645\u0637\u0644\u0648\u0628\u0629.",
      "state": "\u0627\u0644\u0648\u0644\u0627\u064A\u0629",
      "stripe_key": "\u062D\u0642\u0644 \u0645\u0641\u062A\u0627\u062D Stripe \u0645\u0637\u0644\u0648\u0628.",
      "stripe_secret": "\u062D\u0642\u0644 \u0633\u0631 Stripe \u0645\u0637\u0644\u0648\u0628.",
      "subject_required": "\u062D\u0642\u0644 \u0627\u0644\u0645\u0648\u0636\u0648\u0639 \u0645\u0637\u0644\u0648\u0628.",
      "subscriptions": "\u0627\u0644\u0627\u0634\u062A\u0631\u0627\u0643\u0627\u062A",
      "successful": "\u0646\u0627\u062C\u062D",
      "sun": "\u0627\u0644\u0623\u062D\u062F",
      "term_condition": "\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062D\u0643\u0627\u0645",
      "testimonial": "\u0634\u0647\u0627\u062F\u0629",
      "the_description_field_is_required": "\u062D\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0645\u0637\u0644\u0648\u0628.",
      "the_term_conditions": "\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062D\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629.",
      "this_is_analytics_chart": "\u0647\u0630\u0627 \u0647\u0648 \u0645\u062E\u0637\u0637 \u062A\u062D\u0644\u064A\u0644\u0627\u062A VCard \u0627\u0644\u062E\u0627\u0635 \u0628\u0643.",
      "this_month": "\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631",
      "this_week": "\u0647\u0630\u0627 \u0627\u0644\u0623\u0633\u0628\u0648\u0639",
      "thu": "\u0627\u0644\u062E\u0645\u064A\u0633",
      "to": "\u0625\u0644\u0649",
      "today": "\u0627\u0644\u064A\u0648\u0645",
      "too_long": "\u0637\u0648\u064A\u0644 \u062C\u062F\u0627",
      "too_short": "\u0642\u0635\u064A\u0631 \u062C\u062F\u0627",
      "tue": "\u0627\u0644\u062B\u0644\u0627\u062B\u0627\u0621",
      "unavailable": "\u063A\u064A\u0631 \u0645\u062A\u0627\u062D",
      "upload_required": "\u062D\u0642\u0644 \u062A\u062D\u0645\u064A\u0644 \u0627\u0644\u0645\u0644\u0641 \u0645\u0637\u0644\u0648\u0628.",
      "user": "\u0627\u0644\u0645\u0633\u062A\u062E\u062F\u0645",
      "vcard": "\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0627\u062A\u0635\u0627\u0644",
      "vcard_iframe": "\u0625\u0637\u0627\u0631 VCard",
      "vcard_name": "\u0627\u0633\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0634\u062E\u0635\u064A\u0629",
      "vcard_name_required": "\u062D\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0645\u0637\u0644\u0648\u0628",
      "vcard_service": "\u062E\u062F\u0645\u0629 VCard",
      "vcard_testimonial": "\u0634\u0647\u0627\u062F\u0629 VCard",
      "website_field_required": "\u062D\u0642\u0644 \u0627\u0644\u0645\u0648\u0642\u0639 \u0627\u0644\u0625\u0644\u0643\u062A\u0631\u0648\u0646\u064A \u0645\u0637\u0644\u0648\u0628",
      "wed": "\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621",
      "whatsapp_store": "\u0645\u062A\u062C\u0631 \u0648\u0627\u062A\u0633\u0627\u0628",
      "yes": "\u0646\u0639\u0645",
      "yesterday": "\u0627\u0644\u0623\u0645\u0633"
    },
    "de.js": {
      "Yes_Change": "Ja, Genehmigen",
      "add_on": "Hinzuf\xFCgen Auf",
      "address_field": "Das Feld Adresse ist erforderlich.",
      "admin": "Administrator",
      "affiliation_amount_error": "Der Affiliationsbetrag darf 100% nicht \xFCberschreiten",
      "affiliation_email_send": "Einladungs-E-Mail erfolgreich versendet!",
      "agree_term": "Sie m\xFCssen den Nutzungsbedingungen zustimmen.",
      "allowed_file_types": "Erlaubte Dateitypen: png, jpg, jpeg.",
      "allowed_image": "Erlaubte Dateitypen: png, jpg, jpeg.",
      "amount": "Betrag",
      "app_name_required": "Das App-Namen-Feld ist erforderlich",
      "apply": "Anwenden",
      "appointment": "Termin",
      "appointments": "Termine",
      "approved": "Genehmigt",
      "apr": "Apr",
      "are_you_completed": "Sind Sie sicher, dass Sie dies genehmigen m\xF6chten?",
      "are_you_sure": "Sind Sie sicher, dass Sie dies l\xF6schen m\xF6chten",
      "are_you_sure_dublicate_vcard": "Sind Sie sicher, dass Sie diese VCard duplizieren m\xF6chten?",
      "aug": "Aug",
      "back_image_field_required": "R\xFCckbildfeld ist erforderlich",
      "blog": "Blog",
      "blog_description": "Beschreibung",
      "blog_image_required": "Das Feld \u201EBlog-Bild\u201C ist erforderlich.",
      "cancel": "Abbrechen",
      "check_email": "E-Mail existiert bereits.",
      "choose_one_template": "W\xE4hlen Sie eine Vorlage aus",
      "choose_plan": "Plan ausw\xE4hlen",
      "city": "Stadt",
      "click_open_sidebar": "Klicken Sie auf \u201EWeiter\u201C, um die Seitenleiste zu \xF6ffnen.",
      "click_to_add_vcard_name": "Klicken Sie hier, um Ihren Vcard-Namen hinzuzuf\xFCgen.",
      "click_to_create_vcards": "Klicken Sie auf Weiter, um Ihre VCard zu erstellen.",
      "click_to_generate_alias": "Klicken Sie hier, um Ihren URL-Alias \u200B\u200Bzu generieren.",
      "click_to_go_dashboard": "Klicken Sie auf Weiter, um zum Dashboard zu gelangen.",
      "click_to_make_vcards": "Klicken Sie auf \u201EWeiter\u201C, um neue VCards zu erstellen.",
      "click_to_open_edit_sidebar": "Klicken Sie auf \u201EWeiter\u201C, um auf die VCard-Bearbeitungsseitenleiste zuzugreifen.",
      "click_to_preview": "Klicken Sie hier, um eine Vorschau Ihrer VCard anzuzeigen.",
      "click_to_save_vcard": "Klicken Sie auf Weiter, um Ihre VCard zu speichern.",
      "completed": "Abgeschlossen",
      "copied_successfully": "Link erfolgreich kopiert.",
      "country": "Land",
      "coupon_code": "Gutscheincode",
      "coupon_code_apply": "Gutscheincode erfolgreich angewendet.",
      "coupon_code_percent_validation": "Der Rabattcode darf nicht mehr als 100% betragen.",
      "custom": "Benutzerdefiniert",
      "custom_link": "Benutzerdefinierter Link",
      "dec": "Dez",
      "delete": "L\xF6schen",
      "deleted": "Gel\xF6scht",
      "description": "Beschreibung Ihrer VCard eingeben",
      "description_length": "Die Beschreibung muss mindestens 3 Zeichen enthalten.",
      "description_required": "Das Feld \u201EBeschreibung\u201C ist erforderlich.",
      "duplicate": "Duplikat!",
      "duplicate_vcard": "Duplizierte VCard!",
      "duplicate_vcard_create": "Duplizierte VCard erfolgreich erstellt",
      "email": "E-Mail",
      "email_required": "Das E-Mail-Feld ist erforderlich",
      "embedtag": "Tag einbetten",
      "enquiry": "Anfrage",
      "enter_valid_email": "Bitte geben Sie eine g\xFCltige E-Mail-Adresse ein.",
      "enter_vcard_name": "Bitte geben Sie einen Vcard-Namen ein",
      "error": "Fehler",
      "faqs": "FAQs",
      "feb": "Feb",
      "first_name_required": "Das Feld Vorname ist erforderlich.",
      "flat": "Flach",
      "flutterwave_key": "Das Flutterwave-Schl\xFCsselfeld ist erforderlich.",
      "flutterwave_secret": "Das Flutterwave-Geheimnisfeld ist erforderlich.",
      "fri": "Fr",
      "from": "Von",
      "front_image_field_required": "Vorderbildfeld ist erforderlich",
      "gallery": "Galerie",
      "generate_url_alias": "Bitte generieren Sie einen URL-Alias",
      "has_been_completed": "wurde abgeschlossen.",
      "has_been_deleted": "wurde gel\xF6scht.",
      "here_select_vcard_template": "Hier k\xF6nnen Sie Ihre VCard-Vorlage ausw\xE4hlen.",
      "image_too_large": "Ihre Datei ist zu gro\xDF. Die maximal zul\xE4ssige Gr\xF6\xDFe betr\xE4gt 1 MB.",
      "in_progress": "In Bearbeitung",
      "inquries": "Anfrage",
      "invalid_country_code": "Ung\xFCltiger L\xE4ndercode",
      "invalid_email": "E-Mail ist ung\xFCltig",
      "invalid_number": "Ung\xFCltige Nummer",
      "jan": "Jan",
      "jul": "Jul",
      "jun": "Jun",
      "last_30_days": "Letzte 30 Tage",
      "last_7_days": "Letzte 7 Tage",
      "last_name_required": "Das Feld Nachname ist erforderlich.",
      "last_week": "Letzte Woche",
      "loading": "Laden...",
      "location_field_required": "Standortfeld ist erforderlich",
      "logo_field_required": "E-Card-Logo ist erforderlich",
      "logo_image_error": "Die Bildabmessungen m\xFCssen 150x150 Pixel oder kleiner sein.",
      "manual_payment_guide": "Anleitung zur manuellen Zahlung",
      "mar": "M\xE4r",
      "may": "Mai",
      "mon": "Mo",
      "month": "Monat",
      "multi_templates": "Mehrere Vorlagen sind erforderlich",
      "next": "N\xE4chste",
      "nfc_card": "NFC-Karte",
      "nfc_order": "NFC-Bestellung",
      "no": "Nein",
      "nov": "Nov",
      "occupation_field_required": "Berufsfeld ist erforderlich",
      "oct": "Okt",
      "ok": "OK",
      "onesignal_app_id": "Das Feld der OneSignal-App-ID ist erforderlich.",
      "onesignal_rest_api_key": "Das Feld des OneSignal-REST-API-Schl\xFCssels ist erforderlich.",
      "order_placed": "Ihre Bestellung wurde erfolgreich aufgegeben!",
      "password_character": "Das Passwort muss mindestens 8 Zeichen lang sein.",
      "password_must_match": "Das Passwort und die Passwortbest\xE4tigung m\xFCssen \xFCbereinstimmen.",
      "passwords": "Das Passwortfeld ist erforderlich.",
      "payment_not_complete": "Zahlung nicht abgeschlossen",
      "paypal_key": "Das Feld \u201EPaypal-Kunden-ID\u201C ist erforderlich.",
      "paypal_mode": "Das Feld PayPal-Modus ist erforderlich.",
      "paypal_secret": "Das Feld PayPal Secret ist erforderlich.",
      "paystack_key": "Das Paystack-Schl\xFCsselfeld ist erforderlich.",
      "paystack_secret": "Das Paystack-Geheimnisfeld ist erforderlich.",
      "phone": "Telefon",
      "phone_number_required": "Das Feld Telefonnummer ist erforderlich.",
      "phonepe_env_required": "Das Feld Phonepe Env ist erforderlich.",
      "phonepe_merchant_id_required": "Das Feld Phonepe-H\xE4ndler-ID ist erforderlich.",
      "phonepe_merchant_transaction_id_required": "Das Feld \u201EPhonepe-H\xE4ndler-Transaktions-ID\u201C ist erforderlich.",
      "phonepe_merchant_user_id_required": "Das Feld Phonepe-H\xE4ndler-Benutzer-ID ist erforderlich.",
      "phonepe_salt_index_required": "Das Feld \u201EPhonepe Salt Index\u201C ist erforderlich.",
      "phonepe_salt_key_required": "Das Feld \u201EPhonepe Salt Key\u201C ist erforderlich.",
      "plan": "Plan",
      "plan_expire_notification": "Das Feld f\xFCr die Benachrichtigung \xFCber das Ablaufen des Plans ist erforderlich.",
      "please_select_user": "Bitte w\xE4hlen Sie einen Benutzer",
      "please_wait": "Bitte warten...",
      "privacy_policy": "Datenschutzrichtlinie",
      "product": "Produkt",
      "product_added_to_cart": "Produkt wurde erfolgreich in den Warenkorb gelegt!",
      "product_category": "Produktkategorie",
      "product_deleted_from_cart": "Produkt wurde erfolgreich aus dem Warenkorb entfernt!",
      "provide_valid_wbsite_url": "Bitte eine g\xFCltige URL eingeben",
      "purchase": "Kauf",
      "razorpay_key": "Das Rozorpay-Schl\xFCsselfeld ist erforderlich.",
      "razorpay_secret": "Das Feld \u201ERozorpay-Geheimnis\u201C ist erforderlich.",
      "rejected": "Abgelehnt",
      "remove": "Entfernen",
      "sat": "Sa",
      "select_all": "Alles ausw\xE4hlen",
      "select_email_required": "Das Feld \u201EE-Mail senden\u201C ist erforderlich.",
      "select_hour": "Bitte w\xE4hlen Sie Datum oder Stunde",
      "select_one_or_more": "W\xE4hlen Sie eine oder mehrere Funktionen aus",
      "select_payment_type": "W\xE4hle eine Zahlmethode aus",
      "select_user": "Benutzer ausw\xE4hlen",
      "select_vcard": "VCard auswhlen",
      "send_email_description": "Beschreibung",
      "sep": "Sep",
      "short_description": "Geben Sie eine kurze Beschreibung ein",
      "skip": "\xDCberspringen",
      "social_links_img_is_required": "Soziale Links Bild ist erforderlich.",
      "social_links_is_required": "Soziale Links sind erforderlich.",
      "state": "Bundesland",
      "stripe_key": "Das Stripe-Schl\xFCsselfeld ist erforderlich.",
      "stripe_secret": "Das Feld Stripe Secret ist erforderlich.",
      "subject_required": "Das Feld \u201EBetreff\u201C ist erforderlich.",
      "subscriptions": "Abonnements",
      "successful": "Erfolgreich",
      "sun": "So",
      "term_condition": "Nutzungsbedingungen",
      "testimonial": "Referenz",
      "the_term_conditions": "Die Nutzungsbedingungen sind erforderlich.",
      "this_is_analytics_chart": "Dies ist Ihr VCard-Analysediagramm.",
      "this_month": "Dieser Monat",
      "this_week": "Diese Woche",
      "thu": "Do",
      "to": "Bis",
      "today": "Heute",
      "too_long": "Zu lang",
      "too_short": "Zu kurz",
      "tue": "Di",
      "unavailable": "Nicht verf\xFCgbar",
      "upload_required": "Das Feld f\xFCr den Dateiupload ist erforderlich.",
      "user": "Benutzer",
      "vcard": "VCard",
      "vcard_iframe": "VCard iframe",
      "vcard_name": "VCard-Name",
      "vcard_name_required": "VCard-Name ist erforderlich",
      "vcard_service": "VCard-Dienst",
      "vcard_testimonial": "VCard-Testimonial",
      "website_field_required": "Webseitenfeld ist erforderlich",
      "wed": "Mi",
      "whatsapp_store": "WhatsApp-Shop",
      "yes": "Ja",
      "yesterday": "Gestern"
    },
    "en.js": {
      "Yes_Change": "Yes, Approve",
      "add_on": "Add On",
      "added_to_cart": "Added to cart",
      "address_field": "Address Field field is required.",
      "admin": "Admin",
      "affiliation_amount_error": "Affiliation amount cannot exceed 100%",
      "affiliation_email_send": "Invitation email sent successfully!",
      "agree_term": "You must agreed to Terms and conditions.",
      "allowed_file_types": "Allowed file types: png, jpg, jpeg.",
      "allowed_image": "Allowed file types: png, jpg, jpeg.",
      "amount": "Amount",
      "app_name_required": "App Name field is required",
      "apply": "Apply",
      "appointment": "Appointment",
      "appointments": "Appointments",
      "approved": "Approved",
      "apr": "Apr",
      "are_you_completed": "Are you sure, you want to approve this ?",
      "are_you_sure": "Are you sure want to delete this",
      "are_you_sure_dublicate_vcard": "Are you sure want to create duplicate  this VCard ?",
      "aug": "Aug",
      "back_image_field_required": "Back image field is required",
      "blog": "Blog",
      "blog_description": "Description",
      "blog_image_required": "Blog image field is required.",
      "cancel": "Cancel",
      "check_email": "Email already exists.",
      "choose_one_template": "Choose any one template",
      "choose_plan": "Choose Plan",
      "city": "City",
      "click_open_sidebar": "Click on Next to Open Sidebar.",
      "click_to_add_vcard_name": "Click Here to Add Your Vcard Name.",
      "click_to_create_vcards": "Click on Next to Create Your VCard.",
      "click_to_generate_alias": "Click Here to Generate Your URL Alias.",
      "click_to_go_dashboard": "Click on Next to Proceed to Dashboard.",
      "click_to_make_vcards": "Click on Next to Make New VCards.",
      "click_to_open_edit_sidebar": "Click on Next to Access VCard Edit Sidebar.",
      "click_to_preview": "Click Here to Preview Your VCard.",
      "click_to_save_vcard": "Click on Next to Save Your VCard.",
      "completed": "Completed",
      "copied_successfully": "Link copied successfully.",
      "country": "Country",
      "coupon_code": "Coupon Codes",
      "coupon_code_apply": "Coupon Code Applied successfully.",
      "coupon_code_percent_validation": "Coupon discount should not be more than 100%.",
      "custom": "Custom",
      "custom_link": "Custom Link",
      "custom_vcard_number": "Custom VCard No",
      "custom_vcard_price": "Custom VCard No Price",
      "dec": "Dec",
      "delete": "Delete",
      "deleted": "Deleted",
      "description": "Enter Description of Your VCard",
      "description_length": "The description must be at least 3 characters.",
      "description_required": "Description field is required.",
      "duplicate": "Duplicate !",
      "duplicate_vcard": "Duplicate Vcard !",
      "duplicate_vcard_create": "Duplicate Vcard created successfully",
      "email": "Email",
      "email_required": "Email field is required",
      "embedtag": "Embed tag",
      "enquiry": "Enquiry",
      "enter_valid_email": "Please enter valid Email.",
      "enter_vcard_name": "Please enter a Vcard Name",
      "error": "Error",
      "faqs": "FAQs",
      "feb": "Feb",
      "first_name_required": "First Name field is required.",
      "flat": "Flat",
      "flutterwave_key": "Flutterwave key field is required.",
      "flutterwave_secret": "Flutterwave Secret field is required.",
      "fri": "FRI",
      "from": "From",
      "front_image_field_required": "Front image field is required",
      "gallery": "Gallery",
      "generate_url_alias": "Please Generate a URL Alias",
      "has_been_completed": "has been completed.",
      "has_been_deleted": "has been deleted.",
      "here_select_vcard_template": "Here You Can Select Your VCard Template.",
      "image_too_large": "Your file is too large. Maximum size allowed is 1MB.",
      "in_progress": "In Progress",
      "inquries": "Inquiry",
      "invalid_country_code": "Invalid country code",
      "invalid_email": "Email is invalid",
      "invalid_number": "Invalid Number",
      "jan": "Jan",
      "jul": "Jul",
      "jun": "Jun",
      "last_30_days": "Last 30 Day",
      "last_7_days": "Last 7 Day",
      "last_name_required": "Last Name field is required.",
      "last_week": "Last Week",
      "loading": "Loading...",
      "location_field_required": "Location field is required",
      "logo_field_required": "E-Card logo field is required",
      "logo_image_error": "Image dimensions must be 150x150 pixels or less.",
      "manual_payment_guide": "Manual Payment Guide",
      "mar": "Mar",
      "may": "May",
      "mon": "MON",
      "month": "Month",
      "multi_templates": "Multi templates is required",
      "next": "Next",
      "nfc_card": "NFC Card",
      "nfc_order": "NFC Order",
      "no": "No",
      "nov": "Nov",
      "occupation_field_required": "Occupation field is required",
      "oct": "Oct",
      "ok": "Ok",
      "onesignal_app_id": "Onesignal App ID field is required.",
      "onesignal_rest_api_key": "Onesignal Rest Api Key field is required.",
      "order_placed": "Your order has been placed successfully!",
      "password_character": "The password must be at least 8 characters.",
      "password_must_match": "The password and password confirmation must match.",
      "passwords": "The passwords field is required.",
      "payment_not_complete": "Payment Not Completed",
      "paypal_key": "Paypal Client ID field is required.",
      "paypal_mode": "Paypal mode field is required.",
      "paypal_secret": "Paypal secret field is required.",
      "paystack_key": "Paystack key field is required.",
      "paystack_secret": "Paystack Secret field is required.",
      "phone": "Phone",
      "phone_number_required": "Phone Number field is required.",
      "phonepe_env_required": "Phonepe Env field is required.",
      "phonepe_merchant_id_required": "Phonepe Merchant ID field is required.",
      "phonepe_merchant_transaction_id_required": "Phonepe Merchant Transaction ID field is required.",
      "phonepe_merchant_user_id_required": "Phonepe Merchant User ID field is required.",
      "phonepe_salt_index_required": "Phonepe Salt Index field is required.",
      "phonepe_salt_key_required": "Phonepe Salt Key field is required.",
      "plan": "Plan",
      "plan_expire_notification": "Plan Expire Notification field is required.",
      "please_select_user": "Please select a user",
      "please_wait": "Please Wait...",
      "privacy_policy": "Privacy Policy",
      "product": "Product",
      "product_added_to_cart": "Product has been added to your cart successfully!",
      "product_category": "Product Category",
      "product_deleted_from_cart": "Product has been removed from your cart successfully!",
      "provide_valid_wbsite_url": "Enter must be valid url",
      "purchase": "Purchase",
      "razorpay_key": "Rozorpay key field is required.",
      "razorpay_secret": "Rozorpay Secret field is required.",
      "rejected": "Rejected",
      "remove": "Remove",
      "sat": "SAT",
      "select_all": "Select All",
      "select_email_required": "Send Mail field is required.",
      "select_hour": "Please Select Date Or Hour",
      "select_one_or_more": "Select one or more Feature is required",
      "select_payment_type": "Select Payment Type",
      "select_user": "Select User",
      "select_vcard": "Select Vcard",
      "send_email_description": "Description",
      "sep": "Sep",
      "short_description": "Enter Short Description",
      "skip": "Skip",
      "social_links_img_is_required": "Social links Image is required.",
      "social_links_is_required": "Social links is required.",
      "state": "State",
      "stripe_key": "Stripe key field is required.",
      "stripe_secret": "Stripe secret field is required.",
      "subject_required": "Subject field is required.",
      "subscriptions": "Subscriptions",
      "successful": "Successful",
      "sun": "SUN",
      "term_condition": "Terms & Conditions",
      "testimonial": "Testimonial",
      "the_term_conditions": "The Terms & Conditions is required.",
      "this_is_analytics_chart": "This is your VCard analytics Chart.",
      "this_month": "This Month",
      "this_week": "This Week",
      "thu": "THU",
      "to": "To",
      "today": "Today",
      "too_long": "Too long",
      "too_short": "Too short",
      "tue": "TUE",
      "unavailable": "Unavailable",
      "upload_required": "The file upload field is required.",
      "user": "User",
      "vcard": "VCard",
      "vcard_iframe": "Vcard iframe",
      "vcard_name": "VCard Name",
      "vcard_name_required": "Vcard name field is required",
      "vcard_service": "VCard Service",
      "vcard_testimonial": "VCard Testimonial",
      "website_field_required": "Website field is required",
      "wed": "WED",
      "whatsapp_store": "Whatsapp Store",
      "yes": "Yes",
      "yesterday": "Yesterday"
    },
    "es.js": {
      "Yes_Change": "S\xED, Aprobar",
      "add_on": "A\xF1adir",
      "address_field": "El campo de direcci\xF3n es obligatorio.",
      "admin": "Administrador",
      "affiliation_amount_error": "El monto de afiliaci\xF3n no puede exceder el 100%",
      "affiliation_email_send": "\xA1Correo electr\xF3nico de invitaci\xF3n enviado exitosamente!",
      "agree_term": "Debes estar de acuerdo con los t\xE9rminos y condiciones.",
      "allowed_file_types": "Tipos de archivo permitidos: png, jpg, jpeg.",
      "allowed_image": "Tipos de archivo permitidos: png, jpg, jpeg.",
      "amount": "Cantidad",
      "app_name_required": "El campo de nombre de la aplicaci\xF3n es obligatorio",
      "apply": "Aplicar",
      "appointment": "Cita",
      "appointments": "Citas",
      "approved": "Aprobado",
      "apr": "Abr",
      "are_you_completed": "\xBFEst\xE1s seguro de que deseas aprobar esto?",
      "are_you_sure": "\xBFEst\xE1s seguro de que quieres eliminar esto?",
      "are_you_sure_dublicate_vcard": "\xBFEst\xE1s seguro de que quieres duplicar esta VCard?",
      "aug": "Ago",
      "back_image_field_required": "El campo de la imagen posterior es obligatorio",
      "blog": "Blog",
      "blog_description": "Descripci\xF3n",
      "blog_image_required": "El campo de imagen del blog es obligatorio.",
      "cancel": "Cancelar",
      "check_email": "El Email ya existe.",
      "choose_one_template": "Elige una plantilla",
      "choose_plan": "Selecciona un plan",
      "city": "Ciudad",
      "click_open_sidebar": "Haga clic en Siguiente para abrir la barra lateral.",
      "click_to_add_vcard_name": "Haga clic aqu\xED para agregar el nombre de su Vcard.",
      "click_to_create_vcards": "Haga clic en Siguiente para crear su VCard.",
      "click_to_generate_alias": "Haga clic aqu\xED para generar su alias de URL.",
      "click_to_go_dashboard": "Haga clic en Siguiente para pasar al panel.",
      "click_to_make_vcards": "Haga clic en Siguiente para crear nuevas VCards.",
      "click_to_open_edit_sidebar": "Haga clic en Siguiente para acceder a la barra lateral de edici\xF3n de VCard.",
      "click_to_preview": "Haga clic aqu\xED para obtener una vista previa de su VCard.",
      "click_to_save_vcard": "Haga clic en Siguiente para guardar su VCard.",
      "completed": "Completado",
      "copied_successfully": "Enlace copiado exitosamente.",
      "country": "Pa\xEDs",
      "coupon_code": "C\xF3digos de cup\xF3n",
      "coupon_code_apply": "C\xF3digo de cup\xF3n aplicado con \xE9xito.",
      "coupon_code_percent_validation": "El descuento del cup\xF3n no debe ser superior al 100%.",
      "custom": "Personalizado",
      "custom_link": "Enlace Personalizado",
      "dec": "Dic",
      "delete": "Eliminar",
      "deleted": "Eliminado",
      "description": "Ingresa la descripci\xF3n de tu VCard",
      "description_length": "La descripci\xF3n debe tener al menos 3 caracteres.",
      "description_required": "El campo de descripci\xF3n es obligatorio.",
      "duplicate": "Duplicado",
      "duplicate_vcard": "VCard duplicada",
      "duplicate_vcard_create": "VCard duplicada creada exitosamente",
      "email": "Correo electr\xF3nico",
      "email_required": "El campo de correo electr\xF3nico es obligatorio",
      "embedtag": "Etiqueta de inserci\xF3n",
      "enquiry": "Consulta",
      "enter_valid_email": "Por favor, ingresa un correo electr\xF3nico v\xE1lido.",
      "enter_vcard_name": "Por favor ingrese un nombre de Vcard",
      "error": "Error",
      "faqs": "Preguntas frecuentes",
      "feb": "Feb",
      "first_name_required": "El campo de nombre es obligatorio.",
      "flat": "Plano",
      "flutterwave_key": "El campo de clave de Flutterwave es obligatorio.",
      "flutterwave_secret": "El campo de secreto de Flutterwave es obligatorio.",
      "fri": "VIE",
      "from": "Desde",
      "front_image_field_required": "El campo de la imagen frontal es obligatorio",
      "gallery": "Galer\xEDa",
      "generate_url_alias": "Por favor genere un alias de URL",
      "has_been_completed": "ha sido completado.",
      "has_been_deleted": "ha sido eliminado.",
      "here_select_vcard_template": "Aqu\xED puede seleccionar su plantilla VCard.",
      "image_too_large": "Su archivo es demasiado grande. El tama\xF1o m\xE1ximo permitido es 1 MB.",
      "in_progress": "En progreso",
      "inquries": "Consulta",
      "invalid_country_code": "C\xF3digo de pa\xEDs no v\xE1lido",
      "invalid_email": "El correo electr\xF3nico es inv\xE1lido",
      "invalid_number": "N\xFAmero no v\xE1lido",
      "jan": "Ene",
      "jul": "Jul",
      "jun": "Jun",
      "last_30_days": "\xDAltimos 30 d\xEDas",
      "last_7_days": "\xDAltimos 7 d\xEDas",
      "last_name_required": "El campo de apellido es obligatorio.",
      "last_week": "Semana pasada",
      "loading": "Cargando...",
      "location_field_required": "El campo de ubicaci\xF3n es obligatorio",
      "logo_field_required": "El campo del logo de la tarjeta es obligatorio",
      "logo_image_error": "Las dimensiones de la imagen deben ser 150x150 p\xEDxeles o menos.",
      "manual_payment_guide": "Gu\xEDa de pago manual",
      "mar": "Mar",
      "may": "May",
      "mon": "LUN",
      "month": "Mes",
      "multi_templates": "Se requieren varias plantillas",
      "next": "Pr\xF3xima",
      "nfc_card": "Tarjeta NFC",
      "nfc_order": "Orden NFC",
      "no": "No",
      "nov": "Nov",
      "occupation_field_required": "El campo de ocupaci\xF3n es obligatorio",
      "oct": "Oct",
      "ok": "Aceptar",
      "onesignal_app_id": "El campo de ID de aplicaci\xF3n de OneSignal es obligatorio.",
      "onesignal_rest_api_key": "El campo de clave API REST de OneSignal es obligatorio.",
      "order_placed": "\xA1Tu pedido ha sido realizado con \xE9xito!",
      "password_character": "La contrase\xF1a debe tener al menos 8 caracteres.",
      "password_must_match": "La contrase\xF1a y la confirmaci\xF3n de la contrase\xF1a deben coincidir.",
      "passwords": "El campo de contrase\xF1as es obligatorio.",
      "payment_not_complete": "Pago no completado",
      "paypal_key": "El campo ID de cliente de Paypal es obligatorio.",
      "paypal_mode": "El campo de modo de PayPal es obligatorio.",
      "paypal_secret": "El campo de secreto de PayPal es obligatorio.",
      "paystack_key": "El campo de clave de Paystack es obligatorio.",
      "paystack_secret": "El campo de secreto de Paystack es obligatorio.",
      "phone": "Tel\xE9fono",
      "phone_number_required": "El campo de n\xFAmero de tel\xE9fono es obligatorio.",
      "phonepe_env_required": "El campo Phonepe Env es obligatorio.",
      "phonepe_merchant_id_required": "El campo ID de comerciante de Phonepe es obligatorio.",
      "phonepe_merchant_transaction_id_required": "El campo ID de transacci\xF3n del comerciante de Phonepe es obligatorio.",
      "phonepe_merchant_user_id_required": "El campo de identificaci\xF3n de usuario del comerciante de Phonepe es obligatorio.",
      "phonepe_salt_index_required": "El campo \xCDndice de sal de Phonepe es obligatorio.",
      "phonepe_salt_key_required": "El campo Phonepe Salt Key es obligatorio.",
      "plan": "Plan",
      "plan_expire_notification": "El campo de notificaci\xF3n de vencimiento del plan es obligatorio.",
      "please_select_user": "Por favor, seleccione un usuario",
      "please_wait": "Por favor espera...",
      "privacy_policy": "Pol\xEDtica de privacidad",
      "product": "Producto",
      "product_added_to_cart": "\xA1El producto se ha a\xF1adido a tu carrito con \xE9xito!",
      "product_category": "Categor\xEDa de producto",
      "product_deleted_from_cart": "\xA1El producto se ha eliminado de tu carrito con \xE9xito!",
      "provide_valid_wbsite_url": "Ingrese una URL v\xE1lida",
      "purchase": "Compra",
      "razorpay_key": "El campo clave de Rozorpay es obligatorio.",
      "razorpay_secret": "El campo secreto de Rozorpay es obligatorio.",
      "rejected": "Rechazado",
      "remove": "Eliminar",
      "sat": "SAB",
      "select_all": "Seleccionar todo",
      "select_email_required": "El campo Enviar correo es obligatorio.",
      "select_hour": "Por favor, selecciona fecha u hora",
      "select_one_or_more": "Selecciona una o m\xE1s funciones requeridas",
      "select_payment_type": "Seleccione el tipo de pago",
      "select_user": "Seleccionar usuario",
      "select_vcard": "Seleccione Vcard",
      "send_email_description": "Descripci\xF3n",
      "sep": "Sep",
      "short_description": "Ingresa una descripci\xF3n corta",
      "skip": "Saltar",
      "social_links_img_is_required": "Se requiere la imagen de enlaces sociales.",
      "social_links_is_required": "Se requieren enlaces sociales.",
      "state": "Estado",
      "stripe_key": "Se requiere el campo de clave de Stripe.",
      "stripe_secret": "El campo de secreto de Stripe es obligatorio.",
      "subject_required": "El campo Asunto es obligatorio.",
      "subscriptions": "Suscripciones",
      "successful": "Exitoso",
      "sun": "DOM",
      "term_condition": "T\xE9rminos y condiciones",
      "testimonial": "Testimonio",
      "the_term_conditions": "Se requieren los t\xE9rminos y condiciones.",
      "this_is_analytics_chart": "Este es su gr\xE1fico de an\xE1lisis de VCard.",
      "this_month": "Este Mes",
      "this_week": "Esta semana",
      "thu": "JUE",
      "to": "Hasta",
      "today": "Hoy",
      "too_long": "Demasiado largo",
      "too_short": "Demasiado corto",
      "tue": "MAR",
      "unavailable": "No disponible",
      "upload_required": "El campo de carga de archivos es obligatorio.",
      "user": "Usuario",
      "vcard": "VCard",
      "vcard_iframe": "Iframe de VCard",
      "vcard_name": "Nombre de la VCard",
      "vcard_name_required": "El campo de nombre de la tarjeta es obligatorio",
      "vcard_service": "Servicio de VCard",
      "vcard_testimonial": "Testimonio de VCard",
      "website_field_required": "El campo de sitio web es obligatorio",
      "wed": "MIE",
      "whatsapp_store": "Tienda de WhatsApp",
      "yes": "S\xED",
      "yesterday": "Ayer"
    },
    "fr.js": {
      "Yes_Change": "Oui, Approuver",
      "add_on": "Ajouter",
      "address_field": "Le champ Adresse est requis.",
      "admin": "Admin",
      "affiliation_amount_error": "Le montant de l'affiliation ne peut pas d\xE9passer 100%",
      "affiliation_email_send": "E-mail d'invitation envoy\xE9 avec succ\xE8s !",
      "agree_term": "Vous devez accepter les termes et conditions.",
      "allowed_file_types": "Types de fichiers autoris\xE9s : png, jpg, jpeg.",
      "allowed_image": "Types de fichiers autoris\xE9s : png, jpg, jpeg.",
      "amount": "Montant",
      "app_name_required": "Le champ Nom de l'application est requis",
      "apply": "Appliquer",
      "appointment": "Rendez-vous",
      "appointments": "Rendez-vous",
      "approved": "Approuv\xE9",
      "apr": "Avr",
      "are_you_completed": "\xCAtes-vous s\xFBr de vouloir approuver ceci ?",
      "are_you_sure": "\xCAtes-vous s\xFBr de vouloir supprimer ceci",
      "are_you_sure_dublicate_vcard": "\xCAtes-vous s\xFBr de vouloir cr\xE9er une copie de cette VCard ?",
      "aug": "Ao\xFBt",
      "back_image_field_required": "Le champ de l'image arri\xE8re est requis",
      "blog": "Blog",
      "blog_description": "Description",
      "blog_image_required": "Le champ Image du blog est obligatoire.",
      "cancel": "Annuler",
      "check_email": "L'email existe d\xE9j\xE0.",
      "choose_one_template": "Choisissez un mod\xE8le",
      "choose_plan": "Choisissez un plan",
      "city": "Ville",
      "click_open_sidebar": "Cliquez sur Suivant pour ouvrir la barre lat\xE9rale.",
      "click_to_add_vcard_name": "Cliquez ici pour ajouter votre nom de Vcard.",
      "click_to_create_vcards": "Cliquez sur Suivant pour cr\xE9er votre VCard.",
      "click_to_generate_alias": "Cliquez ici pour g\xE9n\xE9rer votre alias d'URL.",
      "click_to_go_dashboard": "Cliquez sur Suivant pour acc\xE9der au tableau de bord.",
      "click_to_make_vcards": "Cliquez sur Suivant pour cr\xE9er de nouvelles VCards.",
      "click_to_open_edit_sidebar": "Cliquez sur Suivant pour acc\xE9der \xE0 la barre lat\xE9rale d'\xE9dition de VCard.",
      "click_to_preview": "Cliquez ici pour pr\xE9visualiser votre VCard.",
      "click_to_save_vcard": "Cliquez sur Suivant pour enregistrer votre VCard.",
      "completed": "Termin\xE9",
      "copied_successfully": "Lien copi\xE9 avec succ\xE8s.",
      "country": "Pays",
      "coupon_code": "Codes de coupon",
      "coupon_code_apply": "Code promo appliqu\xE9 avec succ\xE8s.",
      "coupon_code_percent_validation": "La r\xE9duction du coupon ne doit pas \xEAtre sup\xE9rieure \xE0 100%.",
      "custom": "Personnalis\xE9",
      "custom_link": "Lien Personnalis\xE9",
      "dec": "D\xE9c",
      "delete": "Supprimer",
      "deleted": "Supprim\xE9",
      "description": "Entrez la description de votre VCard",
      "description_length": "La description doit comporter au moins 3 caract\xE8res.",
      "description_required": "Le champ Description est obligatoire.",
      "duplicate": "Dupliqu\xE9 !",
      "duplicate_vcard": "VCard dupliqu\xE9e !",
      "duplicate_vcard_create": "VCard dupliqu\xE9e cr\xE9\xE9e avec succ\xE8s",
      "email": "E-mail",
      "email_required": "Le champ email est obligatoire",
      "embedtag": "Incorporer une balise",
      "enquiry": "Demande",
      "enter_valid_email": "Veuillez entrer une adresse e-mail valide.",
      "enter_vcard_name": "Veuillez entrer un nom de Vcard",
      "error": "Erreur",
      "faqs": "FAQs",
      "feb": "F\xE9v",
      "first_name_required": "Le champ Pr\xE9nom est requis.",
      "flat": "\xC0 plat",
      "flutterwave_key": "Le champ de cl\xE9 Flutterwave est requis.",
      "flutterwave_secret": "Le champ de secret Flutterwave est requis.",
      "fri": "VEN",
      "from": "De",
      "front_image_field_required": "Le champ de l'image avant est requis",
      "gallery": "Galerie",
      "generate_url_alias": "Veuillez g\xE9n\xE9rer un alias d'URL",
      "has_been_completed": "a \xE9t\xE9 termin\xE9.",
      "has_been_deleted": "a \xE9t\xE9 supprim\xE9.",
      "here_select_vcard_template": "Ici, vous pouvez s\xE9lectionner votre mod\xE8le de VCard.",
      "image_too_large": "Votre fichier est trop volumineux. La taille maximale autoris\xE9e est de 1 Mo.",
      "in_progress": "En cours",
      "inquries": "Enqu\xEAte",
      "invalid_country_code": "Code pays invalide",
      "invalid_email": "L'email est invalide",
      "invalid_number": "Num\xE9ro invalide",
      "jan": "Jan",
      "jul": "Juil",
      "jun": "Juin",
      "last_30_days": "Les 30 derniers jours",
      "last_7_days": "Les 7 derniers jours",
      "last_name_required": "Le champ Nom de famille est requis.",
      "last_week": "La semaine derni\xE8re",
      "loading": "Chargement...",
      "location_field_required": "Le champ de localisation est requis",
      "logo_field_required": "Le champ du logo de la carte est requis",
      "logo_image_error": "Les dimensions de l'image doivent \xEAtre de 150x150 pixels ou moins.",
      "manual_payment_guide": "Guide de paiement manuel",
      "mar": "Mar",
      "may": "Mai",
      "mon": "LUN",
      "month": "Mois",
      "multi_templates": "Plusieurs mod\xE8les sont requis",
      "next": "Suivante",
      "nfc_card": "Carte NFC",
      "nfc_order": "Commande NFC",
      "no": "Non",
      "nov": "Nov",
      "occupation_field_required": "Le champ de profession est requis",
      "oct": "Oct",
      "ok": "OK",
      "onesignal_app_id": "Le champ de l\\'identifiant de l\\'application OneSignal est requis.",
      "onesignal_rest_api_key": "Le champ de cl\xE9 API REST de OneSignal est requis.",
      "order_placed": "Votre commande a \xE9t\xE9 pass\xE9e avec succ\xE8s!",
      "password_character": "Le mot de passe doit comporter au moins 8 caract\xE8res.",
      "password_must_match": "Le mot de passe et la confirmation du mot de passe doivent correspondre.",
      "passwords": "Le champ Mots de passe est requis.",
      "payment_not_complete": "Paiement non termin\xE9",
      "paypal_key": "Le champ ID client Paypal est obligatoire.",
      "paypal_mode": "Le champ Mode PayPal est requis.",
      "paypal_secret": "Le champ Secret PayPal est requis.",
      "paystack_key": "Le champ de cl\xE9 Paystack est requis.",
      "paystack_secret": "Le champ de secret Paystack est requis.",
      "phone": "T\xE9l\xE9phone",
      "phone_number_required": "Le champ Num\xE9ro de t\xE9l\xE9phone est requis.",
      "phonepe_env_required": "Le champ Phonepe Env est obligatoire.",
      "phonepe_merchant_id_required": "Le champ Identifiant du marchand Phonepe est obligatoire.",
      "phonepe_merchant_transaction_id_required": "Le champ Identifiant de transaction du marchand Phonepe est obligatoire.",
      "phonepe_merchant_user_id_required": "Le champ Identifiant de l'utilisateur du commer\xE7ant Phonepe est obligatoire.",
      "phonepe_salt_index_required": "Le champ Phonepe Salt Index est obligatoire.",
      "phonepe_salt_key_required": "Le champ Phonepe Salt Key est obligatoire.",
      "plan": "Plan",
      "plan_expire_notification": "Le champ Notification d'expiration du plan est requis.",
      "please_select_user": "Veuillez s\xE9lectionner un utilisateur",
      "please_wait": "Veuillez patienter...",
      "privacy_policy": "Politique de confidentialit\xE9",
      "product": "Produit",
      "product_added_to_cart": "Le produit a \xE9t\xE9 ajout\xE9 \xE0 votre panier avec succ\xE8s!",
      "product_category": "Cat\xE9gorie de produit",
      "product_deleted_from_cart": "Le produit a \xE9t\xE9 supprim\xE9 de votre panier avec succ\xE8s!",
      "provide_valid_wbsite_url": "Veuillez entrer une URL valide",
      "purchase": "Achat",
      "razorpay_key": "Le champ cl\xE9 Rozorpay est obligatoire.",
      "razorpay_secret": "Le champ Rozorpay Secret est obligatoire.",
      "rejected": "Rejet\xE9",
      "remove": "Supprimer",
      "sat": "SAM",
      "select_all": "S\xE9lectionner tout",
      "select_email_required": "Le champ Envoyer un courrier est obligatoire.",
      "select_hour": "Veuillez s\xE9lectionner la date ou l'heure",
      "select_one_or_more": "S\xE9lectionnez une ou plusieurs fonctionnalit\xE9s requises",
      "select_payment_type": "S\xE9lectionnez le type de paiement",
      "select_user": "S\xE9lectionner l'utilisateur",
      "select_vcard": "S\xE9lectionnez la carte virtuelle",
      "send_email_description": "Description",
      "sep": "Sep",
      "short_description": "Entrez une courte description",
      "skip": "Sauter",
      "social_links_img_is_required": "L'image des liens sociaux est requise.",
      "social_links_is_required": "Les liens sociaux sont requis.",
      "state": "\xC9tat",
      "stripe_key": "Le champ cl\xE9 Stripe est requis.",
      "stripe_secret": "Le champ Secret Stripe est requis.",
      "subject_required": "Le champ Objet est obligatoire.",
      "subscriptions": "Abonnements",
      "successful": "R\xE9ussi",
      "sun": "DIM",
      "term_condition": "Conditions g\xE9n\xE9rales",
      "testimonial": "T\xE9moignage",
      "the_term_conditions": "Les conditions g\xE9n\xE9rales sont requises.",
      "this_is_analytics_chart": "Ceci est votre graphique d'analyse VCard.",
      "this_month": "Ce mois-ci",
      "this_week": "Cette semaine",
      "thu": "JEU",
      "to": "\xC0",
      "today": "Aujourd'hui",
      "too_long": "Trop long",
      "too_short": "Trop court",
      "tue": "MAR",
      "unavailable": "Indisponible",
      "upload_required": "Le champ de t\xE9l\xE9chargement de fichier est requis.",
      "user": "Utilisateur",
      "vcard": "VCard",
      "vcard_iframe": "Iframe VCard",
      "vcard_name": "Nom de la VCard",
      "vcard_name_required": "Le champ du nom de la carte est requis",
      "vcard_service": "Service VCard",
      "vcard_testimonial": "T\xE9moignage VCard",
      "website_field_required": "Le champ du site Web est requis",
      "wed": "MER",
      "whatsapp_store": "Boutique WhatsApp",
      "yes": "Oui",
      "yesterday": "Hier"
    },
    "hi.js": {
      "Yes_Change": "\u0939\u093E\u0901, \u0938\u094D\u0935\u0940\u0915\u0943\u0924 \u0915\u0930\u0947\u0902",
      "add_on": "\u0910\u0921 \u0911\u0928",
      "address_field": "\u092A\u0924\u093E \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "admin": "\u0935\u094D\u092F\u0935\u0938\u094D\u0925\u093E\u092A\u0915",
      "affiliation_amount_error": "\u0938\u0902\u092C\u0926\u094D\u0927\u0924\u093E \u0930\u093E\u0936\u093F 100% \u0938\u0947 \u0905\u0927\u093F\u0915 \u0928\u0939\u0940\u0902 \u0939\u094B \u0938\u0915\u0924\u0940\u0964",
      "affiliation_email_send": "\u0906\u092E\u0902\u0924\u094D\u0930\u0923 \u0908\u092E\u0947\u0932 \u0938\u092B\u0932\u0924\u093E\u092A\u0942\u0930\u094D\u0935\u0915 \u092D\u0947\u091C\u093E \u0917\u092F\u093E!",
      "agree_term": "\u0906\u092A\u0915\u094B \u0936\u0930\u094D\u0924\u094B\u0902 \u0914\u0930 \u0928\u093F\u092F\u092E\u094B\u0902 \u0938\u0947 \u0938\u0939\u092E\u0924 \u0939\u094B\u0928\u093E \u0939\u094B\u0917\u093E\u0964",
      "allowed_file_types": "\u0905\u0928\u0941\u092E\u0924 \u092B\u093C\u093E\u0907\u0932 \u092A\u094D\u0930\u0915\u093E\u0930: png, jpg, jpeg\u0964",
      "allowed_image": "\u0905\u0928\u0941\u092E\u0924 \u092B\u093C\u093E\u0907\u0932 \u092A\u094D\u0930\u0915\u093E\u0930: png, jpg, jpeg\u0964",
      "amount": "\u0930\u093E\u0936\u093F",
      "app_name_required": "\u0910\u092A \u0915\u093E \u0928\u093E\u092E \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948",
      "apply": "\u0932\u093E\u0917\u0942 \u0915\u0930\u0947\u0902",
      "appointment": "\u0928\u093F\u092F\u0941\u0915\u094D\u0924\u093F",
      "appointments": "\u0928\u093F\u092F\u0941\u0915\u094D\u0924\u093F\u092F\u093E\u0901",
      "approved": "\u0938\u094D\u0935\u0940\u0915\u0943\u0924",
      "apr": "\u0905\u092A\u094D\u0930\u0948\u0932",
      "are_you_completed": "\u0915\u094D\u092F\u093E \u0906\u092A \u0938\u0941\u0928\u093F\u0936\u094D\u091A\u093F\u0924 \u0939\u0948\u0902 \u0915\u093F \u0906\u092A \u0907\u0938\u0947 \u0938\u094D\u0935\u0940\u0915\u0943\u0924 \u0915\u0930\u0928\u093E \u091A\u093E\u0939\u0924\u0947 \u0939\u0948\u0902?",
      "are_you_sure": "\u0915\u094D\u092F\u093E \u0906\u092A \u0938\u0941\u0928\u093F\u0936\u094D\u091A\u093F\u0924 \u0939\u0948\u0902 \u0915\u093F \u0906\u092A \u0907\u0938\u0947 \u0939\u091F\u093E\u0928\u093E \u091A\u093E\u0939\u0924\u0947 \u0939\u0948\u0902",
      "are_you_sure_dublicate_vcard": "\u0915\u094D\u092F\u093E \u0906\u092A \u0938\u0941\u0928\u093F\u0936\u094D\u091A\u093F\u0924 \u0939\u0948\u0902 \u0915\u093F \u0906\u092A \u0907\u0938 \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0915\u094B \u0921\u0941\u092A\u094D\u0932\u093F\u0915\u0947\u091F \u0915\u0930\u0928\u093E \u091A\u093E\u0939\u0924\u0947 \u0939\u0948\u0902?",
      "are_you_sure_want_to_delete_selected_Vcards": "\u0915\u094D\u092F\u093E \u0906\u092A \u0938\u0941\u0928\u093F\u0936\u094D\u091A\u093F\u0924 \u0939\u0948\u0902 \u0915\u093F \u0906\u092A \u091A\u092F\u0928\u093F\u0924 \"\u0935\u0940\u0915\u093E\u0930\u094D\u0921\" \u0915\u094B \u0939\u091F\u093E\u0928\u093E \u091A\u093E\u0939\u0924\u0947 \u0939\u0948\u0902?",
      "aug": "\u0905\u0917\u0938\u094D\u0924",
      "back_image_field_required": "\u092A\u0940\u091B\u0947 \u0915\u0940 \u091B\u0935\u093F \u0915\u093E \u0915\u094D\u0937\u0947\u0924\u094D\u0930 \u0905\u0928\u093F\u0935\u093E\u0930\u094D\u092F \u0939\u0948",
      "blog": "\u092C\u094D\u0932\u0949\u0917",
      "blog_description": "\u0935\u093F\u0935\u0930\u0923",
      "blog_image_required": "\u092C\u094D\u0932\u0949\u0917 \u091B\u0935\u093F \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "cancel": "\u0930\u0926\u094D\u0926 \u0915\u0930\u0947\u0902",
      "check_email": "\u0908\u092E\u0947\u0932 \u092A\u0939\u0932\u0947 \u0938\u0947 \u092E\u094C\u091C\u0942\u0926 \u0939\u0948\u0964",
      "choose_one_template": "\u0915\u0943\u092A\u092F\u093E \u0915\u094B\u0908 \u090F\u0915 \u091F\u0947\u092E\u094D\u092A\u094D\u0932\u0947\u091F \u091A\u0941\u0928\u0947\u0902",
      "choose_plan": "\u092F\u094B\u091C\u0928\u093E \u091A\u0941\u0928\u0947\u0902",
      "city": "\u0936\u0939\u0930",
      "click_open_sidebar": "\u0938\u093E\u0907\u0921\u092C\u093E\u0930 \u0916\u094B\u0932\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u0905\u0917\u0932\u093E \u092A\u0930 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_add_vcard_name": "\u0905\u092A\u0928\u093E \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0928\u093E\u092E \u091C\u094B\u0921\u093C\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u092F\u0939\u093E\u0901 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_create_vcards": "\u0905\u092A\u0928\u0947 \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u092C\u0928\u093E\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u0905\u0917\u0932\u093E \u092A\u0930 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_generate_alias": "\u0905\u092A\u0928\u093E \u092F\u0942\u0906\u0930\u090F\u0932 \u0909\u092A\u0928\u093E\u092E \u091C\u0928\u0930\u0947\u091F \u0915\u0930\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u092F\u0939\u093E\u0901 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_go_dashboard": "\u0921\u0948\u0936\u092C\u094B\u0930\u094D\u0921 \u092A\u0930 \u091C\u093E\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u0905\u0917\u0932\u093E \u092A\u0930 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_make_vcards": "\u0928\u090F \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u092C\u0928\u093E\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u0905\u0917\u0932\u093E \u092A\u0930 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_open_edit_sidebar": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0938\u0902\u092A\u093E\u0926\u0928 \u0938\u093E\u0907\u0921\u092C\u093E\u0930 \u0924\u0915 \u092A\u0939\u0941\u0901\u091A\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u0905\u0917\u0932\u093E \u092A\u0930 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_preview": "\u0905\u092A\u0928\u0947 \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0915\u093E \u092A\u0942\u0930\u094D\u0935\u093E\u0935\u0932\u094B\u0915\u0928 \u0915\u0930\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u092F\u0939\u093E\u0901 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "click_to_save_vcard": "\u0905\u092A\u0928\u0947 \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0915\u094B \u0938\u0939\u0947\u091C\u0928\u0947 \u0915\u0947 \u0932\u093F\u090F \u0905\u0917\u0932\u093E \u092A\u0930 \u0915\u094D\u0932\u093F\u0915 \u0915\u0930\u0947\u0902\u0964",
      "completed": "\u092A\u0942\u0930\u094D\u0923",
      "copied_successfully": "\u0932\u093F\u0902\u0915 \u0938\u092B\u0932\u0924\u093E\u092A\u0942\u0930\u094D\u0935\u0915 \u0915\u0949\u092A\u0940 \u0939\u094B \u0917\u092F\u093E\u0964",
      "country": "\u0926\u0947\u0936",
      "coupon_code": "\u0915\u0942\u092A\u0928 \u0915\u094B\u0921",
      "coupon_code_apply": "\u0915\u0942\u092A\u0928 \u0915\u094B\u0921 \u0938\u092B\u0932\u0924\u093E\u092A\u0942\u0930\u094D\u0935\u0915 \u0932\u093E\u0917\u0942 \u0915\u093F\u092F\u093E \u0917\u092F\u093E\u0964",
      "coupon_code_percent_validation": "\u0915\u0942\u092A\u0928 \u091B\u0942\u091F 100% \u0938\u0947 \u0905\u0927\u093F\u0915 \u0928\u0939\u0940\u0902 \u0939\u094B\u0928\u0940 \u091A\u093E\u0939\u093F\u090F\u0964",
      "custom": "\u0915\u0938\u094D\u091F\u092E",
      "custom_link": "\u0915\u0938\u094D\u091F\u092E \u0932\u093F\u0902\u0915",
      "custom_vcard_number": "\u0915\u0938\u094D\u091F\u092E \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0928\u0902\u092C\u0930",
      "custom_vcard_price": "\u0915\u0938\u094D\u091F\u092E \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0928\u0902\u092C\u0930 \u092E\u0942\u0932\u094D\u092F",
      "dec": "\u0926\u093F\u0938\u0902\u092C\u0930",
      "default_plan": "\u0921\u093F\u092B\u093C\u0949\u0932\u094D\u091F \u092F\u094B\u091C\u0928\u093E",
      "delete": "\u0939\u091F\u093E\u090F\u0901",
      "deleted": "\u0939\u091F\u093E\u092F\u093E \u0917\u092F\u093E",
      "description": "\u0905\u092A\u0928\u0947 \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0915\u093E \u0935\u093F\u0935\u0930\u0923 \u0926\u0930\u094D\u091C \u0915\u0930\u0947\u0902",
      "description_length": "\u0935\u093F\u0935\u0930\u0923 \u092E\u0947\u0902 \u0915\u092E \u0938\u0947 \u0915\u092E 3 \u0935\u0930\u094D\u0923 \u0939\u094B\u0928\u0947 \u091A\u093E\u0939\u093F\u090F\u0964",
      "description_required": "\u0935\u093F\u0935\u0930\u0923 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "duplicate": "\u0921\u0941\u092A\u094D\u0932\u093F\u0915\u0947\u091F!",
      "duplicate_vcard": "\u0921\u0941\u092A\u094D\u0932\u093F\u0915\u0947\u091F \u0935\u0940\u0915\u093E\u0930\u094D\u0921!",
      "duplicate_vcard_create": "\u0921\u0941\u092A\u094D\u0932\u093F\u0915\u0947\u091F \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0938\u092B\u0932\u0924\u093E\u092A\u0942\u0930\u094D\u0935\u0915 \u092C\u0928\u093E\u092F\u093E \u0917\u092F\u093E",
      "email": "\u0908\u092E\u0947\u0932",
      "email_required": "\u0908\u092E\u0947\u0932 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "embedtag": "\u091F\u0948\u0917 \u090F\u092E\u094D\u092C\u0947\u0921 \u0915\u0930\u0947\u0902",
      "enquiry": "\u092A\u0942\u091B\u0924\u093E\u091B",
      "enter_valid_email": "\u0915\u0943\u092A\u092F\u093E \u092E\u093E\u0928\u094D\u092F \u0908\u092E\u0947\u0932 \u0926\u0930\u094D\u091C \u0915\u0930\u0947\u0902\u0964",
      "enter_vcard_name": "\u0915\u0943\u092A\u092F\u093E \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0928\u093E\u092E \u0926\u0930\u094D\u091C \u0915\u0930\u0947\u0902",
      "error": "\u0924\u094D\u0930\u0941\u091F\u093F",
      "faqs": "\u0938\u093E\u092E\u093E\u0928\u094D\u092F \u092A\u094D\u0930\u0936\u094D\u0928",
      "feb": "\u092B\u0930",
      "first_name_required": "\u092A\u0939\u0932\u093E \u0928\u093E\u092E \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "flat": "\u092B\u094D\u0932\u0948\u091F",
      "flutterwave_key": "\u092B\u093C\u094D\u0932\u091F\u0930\u0935\u0947\u0935 \u0915\u0941\u0902\u091C\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "flutterwave_secret": "\u092B\u093C\u094D\u0932\u091F\u0930\u0935\u0947\u0935 \u0938\u0940\u0915\u094D\u0930\u0947\u091F \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "fri": "\u0936\u0941\u0915\u094D\u0930",
      "from": "\u0938\u0947",
      "front_image_field_required": "\u0938\u093E\u092E\u0928\u0947 \u0915\u0940 \u091B\u0935\u093F \u0915\u093E \u0915\u094D\u0937\u0947\u0924\u094D\u0930 \u0905\u0928\u093F\u0935\u093E\u0930\u094D\u092F \u0939\u0948",
      "gallery": "\u0917\u0948\u0932\u0930\u0940",
      "generate_url_alias": "\u0915\u0943\u092A\u092F\u093E \u090F\u0915 \u092F\u0942\u0906\u0930\u090F\u0932 \u0909\u092A\u0928\u093E\u092E \u091C\u0928\u0930\u0947\u091F \u0915\u0930\u0947\u0902",
      "has_been_completed": "\u092A\u0942\u0930\u093E \u0939\u094B \u0917\u092F\u093E \u0939\u0948\u0964",
      "has_been_deleted": "\u0939\u091F\u093E \u0926\u093F\u092F\u093E \u0917\u092F\u093E \u0939\u0948\u0964",
      "here_select_vcard_template": "\u092F\u0939\u093E\u0901 \u0906\u092A \u0905\u092A\u0928\u093E \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u091F\u0947\u092E\u094D\u092A\u0932\u0947\u091F \u091A\u0941\u0928 \u0938\u0915\u0924\u0947 \u0939\u0948\u0902\u0964",
      "image_too_large": "\u0906\u092A\u0915\u0940 \u092B\u093C\u093E\u0907\u0932 \u092C\u0939\u0941\u0924 \u092C\u0921\u093C\u0940 \u0939\u0948. \u0905\u0927\u093F\u0915\u0924\u092E \u0905\u0928\u0941\u092E\u0924 \u0906\u0915\u093E\u0930 1MB \u0939\u0948.",
      "in_progress": "\u092A\u094D\u0930\u0917\u0924\u093F \u092E\u0947\u0902",
      "inquries": "\u0905\u0928\u0941\u0938\u0902\u0927\u093E\u0928",
      "invalid_country_code": "\u0905\u092E\u093E\u0928\u094D\u092F \u0926\u0947\u0936 \u0915\u094B\u0921",
      "invalid_email": "\u0908\u092E\u0947\u0932 \u0905\u092E\u093E\u0928\u094D\u092F \u0939\u0948",
      "invalid_number": "\u0905\u092E\u093E\u0928\u094D\u092F \u0938\u0902\u0916\u094D\u092F\u093E",
      "jan": "\u091C\u0928",
      "jul": "\u091C\u0941\u0932\u093E\u0908",
      "jun": "\u091C\u0942\u0928",
      "last_30_days": "\u092A\u093F\u091B\u0932\u0947 30 \u0926\u093F\u0928",
      "last_7_days": "\u092A\u093F\u091B\u0932\u0947 7 \u0926\u093F\u0928",
      "last_name_required": "\u0905\u0902\u0924\u093F\u092E \u0928\u093E\u092E \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "last_week": "\u092A\u093F\u091B\u0932\u0947 \u0938\u092A\u094D\u0924\u093E\u0939",
      "loading": "\u0932\u094B\u0921 \u0939\u094B \u0930\u0939\u093E \u0939\u0948...",
      "location_field_required": "\u0938\u094D\u0925\u093E\u0928 \u0915\u093E \u0915\u094D\u0937\u0947\u0924\u094D\u0930 \u0905\u0928\u093F\u0935\u093E\u0930\u094D\u092F \u0939\u0948",
      "logo_field_required": "\u0908-\u0915\u093E\u0930\u094D\u0921 \u0932\u094B\u0917\u094B \u0915\u093E \u0915\u094D\u0937\u0947\u0924\u094D\u0930 \u0905\u0928\u093F\u0935\u093E\u0930\u094D\u092F \u0939\u0948",
      "logo_image_error": "\u091B\u0935\u093F \u0915\u093E \u0906\u0915\u093E\u0930 150x150 \u092A\u093F\u0915\u094D\u0938\u0947\u0932 \u092F\u093E \u0909\u0938\u0938\u0947 \u0915\u092E \u0939\u094B\u0928\u093E \u091A\u093E\u0939\u093F\u090F\u0964",
      "manual_payment_guide": "\u092E\u0948\u0928\u0941\u0905\u0932 \u092D\u0941\u0917\u0924\u093E\u0928 \u0917\u093E\u0907\u0921",
      "mar": "\u092E\u093E\u0930\u094D\u091A",
      "may": "\u092E\u0908",
      "mon": "\u0938\u094B\u092E",
      "month": "\u092E\u0939\u0940\u0928\u093E",
      "multi_templates": "\u092E\u0932\u094D\u091F\u0940 \u091F\u0947\u092E\u094D\u092A\u094D\u0932\u0947\u091F\u094D\u0938 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0902",
      "next": "\u0905\u0917\u0932\u093E",
      "nfc_card": "\u090F\u0928\u090F\u092B\u0938\u0940 \u0915\u093E\u0930\u094D\u0921",
      "nfc_order": "\u090F\u0928\u090F\u092B\u0938\u0940 \u0911\u0930\u094D\u0921\u0930",
      "no": "\u0928\u0939\u0940\u0902",
      "nov": "\u0928\u0935\u0902\u092C\u0930",
      "occupation_field_required": "\u0935\u094D\u092F\u0935\u0938\u093E\u092F \u0915\u093E \u0915\u094D\u0937\u0947\u0924\u094D\u0930 \u0905\u0928\u093F\u0935\u093E\u0930\u094D\u092F \u0939\u0948",
      "oct": "\u0905\u0915\u094D\u091F\u0942\u092C\u0930",
      "ok": "\u0920\u0940\u0915 \u0939\u0948",
      "onesignal_app_id": "OneSignal \u0910\u092A \u0906\u0908\u0921\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "onesignal_rest_api_key": "OneSignal \u0930\u0947\u0938\u094D\u091F \u090F\u092A\u0940\u0906\u0908 \u0915\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "order_placed": "\u0906\u092A\u0915\u093E \u0911\u0930\u094D\u0921\u0930 \u0938\u092B\u0932\u0924\u093E\u092A\u0942\u0930\u094D\u0935\u0915 \u092A\u094D\u0932\u0947\u0938 \u0915\u0930 \u0926\u093F\u092F\u093E \u0917\u092F\u093E \u0939\u0948!",
      "password_character": "\u092A\u093E\u0938\u0935\u0930\u094D\u0921 \u092E\u0947\u0902 \u0915\u092E \u0938\u0947 \u0915\u092E 8 \u0935\u0930\u094D\u0923 \u0939\u094B\u0928\u0947 \u091A\u093E\u0939\u093F\u090F\u0964",
      "password_must_match": "\u092A\u093E\u0938\u0935\u0930\u094D\u0921 \u0914\u0930 \u092A\u093E\u0938\u0935\u0930\u094D\u0921 \u092A\u0941\u0937\u094D\u091F\u093F \u092E\u0947\u0932 \u0916\u093E\u0928\u093E \u091A\u093E\u0939\u093F\u090F\u0964",
      "passwords": "\u092A\u093E\u0938\u0935\u0930\u094D\u0921 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "payment_not_complete": "\u092D\u0941\u0917\u0924\u093E\u0928 \u092A\u0942\u0930\u093E \u0928\u0939\u0940\u0902 \u0939\u0941\u0906",
      "paypal_key": "PayPal \u0915\u094D\u0932\u093E\u0907\u0902\u091F \u0906\u0908\u0921\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "paypal_mode": "PayPal \u092E\u094B\u0921 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "paypal_secret": "PayPal \u0938\u0940\u0915\u094D\u0930\u0947\u091F \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "paystack_key": "\u092A\u0947\u0938\u094D\u091F\u0948\u0915 \u0915\u0941\u0902\u091C\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "paystack_secret": "\u092A\u0947\u0938\u094D\u091F\u0948\u0915 \u0938\u0940\u0915\u094D\u0930\u0947\u091F \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "phone": "\u092B\u094B\u0928",
      "phone_number_required": "\u092B\u094B\u0928 \u0928\u0902\u092C\u0930 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "phonepe_env_required": "PhonePe \u0935\u093E\u0924\u093E\u0935\u0930\u0923 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "phonepe_merchant_id_required": "PhonePe \u0935\u094D\u092F\u093E\u092A\u093E\u0930\u0940 \u0906\u0908\u0921\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "phonepe_merchant_transaction_id_required": "PhonePe \u0935\u094D\u092F\u093E\u092A\u093E\u0930\u0940 \u0932\u0947\u0928-\u0926\u0947\u0928 \u0906\u0908\u0921\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "phonepe_merchant_user_id_required": "PhonePe \u0935\u094D\u092F\u093E\u092A\u093E\u0930\u0940 \u0909\u092A\u092F\u094B\u0917\u0915\u0930\u094D\u0924\u093E \u0906\u0908\u0921\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "phonepe_salt_index_required": "PhonePe \u0938\u0949\u0932\u094D\u091F \u0907\u0902\u0921\u0947\u0915\u094D\u0938 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "phonepe_salt_key_required": "PhonePe \u0938\u0949\u0932\u094D\u091F \u0915\u0941\u0902\u091C\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "plan": "\u092F\u094B\u091C\u0928\u093E",
      "plan_expire_notification": "\u092F\u094B\u091C\u0928\u093E \u0938\u092E\u093E\u092A\u094D\u0924\u093F \u0938\u0942\u091A\u0928\u093E \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "please_select_user": "\u0915\u0943\u092A\u092F\u093E \u090F\u0915 \u0909\u092A\u092F\u094B\u0917\u0915\u0930\u094D\u0924\u093E \u091A\u092F\u0928 \u0915\u0930\u0947\u0902",
      "please_wait": "\u0915\u0943\u092A\u092F\u093E \u092A\u094D\u0930\u0924\u0940\u0915\u094D\u0937\u093E \u0915\u0930\u0947\u0902...",
      "privacy_policy": "\u0917\u094B\u092A\u0928\u0940\u092F\u0924\u093E \u0928\u0940\u0924\u093F",
      "product": "\u0909\u0924\u094D\u092A\u093E\u0926",
      "product_added_to_cart": "\u092A\u094D\u0930\u094B\u0921\u0915\u094D\u091F \u0915\u094B \u0938\u092B\u0932\u0924\u093E\u092A\u0942\u0930\u094D\u0935\u0915 \u0906\u092A\u0915\u0947 \u0915\u093E\u0930\u094D\u091F \u092E\u0947\u0902 \u091C\u094B\u0921\u093C\u093E \u0917\u092F\u093E \u0939\u0948!",
      "product_category": "\u0909\u0924\u094D\u092A\u093E\u0926 \u0936\u094D\u0930\u0947\u0923\u0940",
      "product_deleted_from_cart": "\u092A\u094D\u0930\u094B\u0921\u0915\u094D\u091F \u0915\u094B \u0938\u092B\u0932\u0924\u093E\u092A\u0942\u0930\u094D\u0935\u0915 \u0906\u092A\u0915\u0947 \u0915\u093E\u0930\u094D\u091F \u0938\u0947 \u0939\u091F\u093E \u0926\u093F\u092F\u093E \u0917\u092F\u093E \u0939\u0948!",
      "provide_valid_wbsite_url": "\u0915\u0943\u092A\u092F\u093E \u090F\u0915 \u092E\u093E\u0928\u094D\u092F \u092F\u0942\u0906\u0930\u090F\u0932 \u0926\u0930\u094D\u091C \u0915\u0930\u0947\u0902",
      "purchase": "\u0916\u0930\u0940\u0926",
      "razorpay_key": "\u0930\u0947\u091C\u0930\u092A\u0947 \u0915\u0941\u0902\u091C\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "razorpay_secret": "\u0930\u0947\u091C\u0930\u092A\u0947 \u0938\u0940\u0915\u094D\u0930\u0947\u091F \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "rejected": "\u0905\u0938\u094D\u0935\u0940\u0915\u0943\u0924",
      "remove": "\u0939\u091F\u093E\u090F\u0901",
      "sat": "\u0936\u0928\u093F",
      "select_all": "\u0938\u092D\u0940 \u091A\u0941\u0928\u0947\u0902",
      "select_email_required": "\u092E\u0947\u0932 \u092D\u0947\u091C\u0928\u0947 \u0915\u093E \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "select_hour": "\u0915\u0943\u092A\u092F\u093E \u0924\u093F\u0925\u093F \u092F\u093E \u0938\u092E\u092F \u091A\u0941\u0928\u0947\u0902",
      "select_one_or_more": "\u090F\u0915 \u092F\u093E \u0905\u0927\u093F\u0915 \u0935\u093F\u0915\u0932\u094D\u092A \u091A\u0941\u0928\u0928\u093E \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948",
      "select_payment_type": "\u092D\u0941\u0917\u0924\u093E\u0928 \u092A\u094D\u0930\u0915\u093E\u0930 \u091A\u0941\u0928\u0947\u0902",
      "select_user": "\u0909\u092A\u092F\u094B\u0917\u0915\u0930\u094D\u0924\u093E \u091A\u0941\u0928\u0947\u0902",
      "select_vcard": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u091A\u0941\u0928\u0947\u0902",
      "send_email_description": "\u0935\u093F\u0935\u0930\u0923",
      "sep": "\u0938\u093F\u0924\u0902\u092C\u0930",
      "short_description": "\u0938\u0902\u0915\u094D\u0937\u093F\u092A\u094D\u0924 \u0935\u093F\u0935\u0930\u0923 \u0926\u0930\u094D\u091C \u0915\u0930\u0947\u0902",
      "skip": "\u091B\u094B\u0921\u093C\u0947\u0902",
      "social_links_img_is_required": "\u0938\u094B\u0936\u0932 \u0932\u093F\u0902\u0915 \u0915\u0940 \u091B\u0935\u093F \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "social_links_is_required": "\u0938\u094B\u0936\u0932 \u0932\u093F\u0902\u0915 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "state": "\u0930\u093E\u091C\u094D\u092F",
      "stripe_key": "\u0938\u094D\u091F\u094D\u0930\u093E\u0907\u092A \u0915\u0941\u0902\u091C\u0940 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "stripe_secret": "\u0938\u094D\u091F\u094D\u0930\u093E\u0907\u092A \u0938\u0940\u0915\u094D\u0930\u0947\u091F \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "subject_required": "\u0935\u093F\u0937\u092F \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "subscriptions": "\u0938\u0926\u0938\u094D\u092F\u0924\u093E\u090F\u0901",
      "successful": "\u0938\u092B\u0932",
      "sun": "\u0930\u0935\u093F",
      "term_condition": "\u0936\u0930\u094D\u0924\u0947\u0902 \u0914\u0930 \u0928\u093F\u092F\u092E",
      "testimonial": "\u092A\u094D\u0930\u0936\u0902\u0938\u093E\u092A\u0924\u094D\u0930",
      "the_description_field_is_required": "\u0935\u093F\u0935\u0930\u0923 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "the_term_conditions": "\u0936\u0930\u094D\u0924\u0947\u0902 \u0914\u0930 \u0928\u093F\u092F\u092E \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0902\u0964",
      "this_is_analytics_chart": "\u092F\u0939 \u0906\u092A\u0915\u093E \u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u090F\u0928\u093E\u0932\u093F\u091F\u093F\u0915\u094D\u0938 \u091A\u093E\u0930\u094D\u091F \u0939\u0948\u0964",
      "this_month": "\u0907\u0938 \u092E\u0939\u0940\u0928\u0947",
      "this_week": "\u0907\u0938 \u0938\u092A\u094D\u0924\u093E\u0939",
      "thu": "\u0917\u0941\u0930\u0941",
      "to": "\u0924\u0915",
      "today": "\u0906\u091C",
      "too_long": "\u092C\u0939\u0941\u0924 \u0932\u0902\u092C\u093E",
      "too_short": "\u092C\u0939\u0941\u0924 \u091B\u094B\u091F\u093E",
      "tue": "\u092E\u0902\u0917\u0932",
      "unavailable": "\u0909\u092A\u0932\u092C\u094D\u0927 \u0928\u0939\u0940\u0902",
      "upload_required": "\u092B\u093C\u093E\u0907\u0932 \u0905\u092A\u0932\u094B\u0921 \u092B\u093C\u0940\u0932\u094D\u0921 \u0906\u0935\u0936\u094D\u092F\u0915 \u0939\u0948\u0964",
      "user": "\u0909\u092A\u092F\u094B\u0917\u0915\u0930\u094D\u0924\u093E",
      "vcard": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921",
      "vcard_iframe": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0906\u0908\u092B\u094D\u0930\u0947\u092E",
      "vcard_name": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0928\u093E\u092E",
      "vcard_name_required": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0928\u093E\u092E \u0915\u093E \u0915\u094D\u0937\u0947\u0924\u094D\u0930 \u0905\u0928\u093F\u0935\u093E\u0930\u094D\u092F \u0939\u0948",
      "vcard_service": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u0938\u0947\u0935\u093E",
      "vcard_testimonial": "\u0935\u0940\u0915\u093E\u0930\u094D\u0921 \u092A\u094D\u0930\u0936\u0902\u0938\u093E\u092A\u0924\u094D\u0930",
      "website_field_required": "\u0935\u0947\u092C\u0938\u093E\u0907\u091F \u0915\u093E \u0915\u094D\u0937\u0947\u0924\u094D\u0930 \u0905\u0928\u093F\u0935\u093E\u0930\u094D\u092F \u0939\u0948",
      "wed": "\u092C\u0941\u0927",
      "whatsapp_store": "\u0935\u094D\u0939\u093E\u091F\u094D\u0938\u090F\u092A \u0938\u094D\u091F\u094B\u0930",
      "yes": "\u0939\u093E\u0901",
      "yesterday": "\u0915\u0932"
    },
    "it.js": {
      "Yes_Change": "S\xEC, Approva",
      "add_on": "Aggiungi",
      "address_field": "Il campo Indirizzo \xE8 obbligatorio.",
      "admin": "Admin",
      "affiliation_amount_error": "L'importo dell'affiliazione non pu\xF2 superare il 100%",
      "affiliation_email_send": "Email di invito inviata con successo!",
      "agree_term": "Devi accettare i Termini e condizioni.",
      "allowed_file_types": "Tipi di file consentiti: png, jpg, jpeg.",
      "allowed_image": "Tipi di file consentiti: png, jpg, jpeg.",
      "amount": "Importo",
      "app_name_required": "Il campo Nome App \xE8 obbligatorio",
      "apply": "Applica",
      "appointment": "Appuntamento",
      "appointments": "Appuntamenti",
      "approved": "Approvato",
      "apr": "Apr",
      "are_you_completed": "Sei sicuro di voler approvare questo?",
      "are_you_sure": "Sei sicuro di voler eliminare questo",
      "are_you_sure_dublicate_vcard": "Sei sicuro di voler duplicare questo VCard?",
      "aug": "Ago",
      "back_image_field_required": "Il campo dellimmagine posteriore \xE8 obbligatorio",
      "blog": "Blog",
      "blog_description": "Descrizione",
      "blog_image_required": "Il campo immagine del blog \xE8 obbligatorio.",
      "cancel": "Annulla",
      "check_email": "Email gi\xE0 esistente.",
      "choose_one_template": "Scegli un qualsiasi template",
      "choose_plan": "Scegli un piano",
      "city": "Citt\xE0",
      "click_open_sidebar": "Fai clic su Avanti per aprire la barra laterale.",
      "click_to_add_vcard_name": "Fai clic qui per aggiungere il nome della tua Vcard.",
      "click_to_create_vcards": "Fai clic su Avanti per creare la tua VCard.",
      "click_to_generate_alias": "Fai clic qui per generare il tuo alias URL.",
      "click_to_go_dashboard": "Fai clic su Avanti per accedere alla Dashboard.",
      "click_to_make_vcards": "Fai clic su Avanti per creare nuove VCard.",
      "click_to_open_edit_sidebar": "Fai clic su Avanti per accedere alla barra laterale di modifica della VCard.",
      "click_to_preview": "Fai clic qui per visualizzare l'anteprima della tua VCard.",
      "click_to_save_vcard": "Fai clic su Avanti per salvare la tua VCard.",
      "completed": "Completato",
      "copied_successfully": "Link copiato con successo.",
      "country": "Paese",
      "coupon_code": "Codici Coupon",
      "coupon_code_apply": "Codice coupon applicato con successo.",
      "coupon_code_percent_validation": "Lo sconto del coupon non pu\xF2 essere superiore al 100%.",
      "custom": "Personalizzato",
      "custom_link": "Collegamento Personalizzato",
      "dec": "Dic",
      "delete": "Elimina",
      "deleted": "Eliminato",
      "description": "Inserisci la descrizione del tuo VCard",
      "description_length": "La descrizione deve contenere almeno 3 caratteri.",
      "description_required": "Il campo descrizione \xE8 obbligatorio.",
      "duplicate": "Duplicato!",
      "duplicate_vcard": "Vcard duplicato!",
      "duplicate_vcard_create": "Duplicato di Vcard creato con successo",
      "email": "Email",
      "email_required": "Il campo email \xE8 obbligatorio",
      "embedtag": "Tag incorporato",
      "enquiry": "Richiesta",
      "enter_valid_email": "Inserisci un'email valida.",
      "enter_vcard_name": "Si prega di inserire un nome Vcard",
      "error": "Errore",
      "faqs": "Domande frequenti",
      "feb": "Feb",
      "first_name_required": "Il campo Nome \xE8 obbligatorio.",
      "flat": "Flat",
      "flutterwave_key": "Il campo Chiave Flutterwave \xE8 obbligatorio.",
      "flutterwave_secret": "Il campo Segreto Flutterwave \xE8 obbligatorio.",
      "fri": "VEN",
      "from": "Da",
      "front_image_field_required": "Il campo dellimmagine frontale \xE8 obbligatorio",
      "gallery": "Galleria",
      "generate_url_alias": "Si prega di generare un alias URL",
      "has_been_completed": "\xE8 stato completato.",
      "has_been_deleted": "\xE8 stato eliminato.",
      "here_select_vcard_template": "Qui puoi selezionare il template della tua VCard.",
      "image_too_large": "Il tuo file \xE8 troppo grande. La dimensione massima consentita \xE8 1 MB.",
      "in_progress": "In corso",
      "inquries": "Richieste",
      "invalid_country_code": "Prefisso internazionale non valido",
      "invalid_email": "L'email non \xE8 valida",
      "invalid_number": "Numero non valido",
      "jan": "Gen",
      "jul": "Lug",
      "jun": "Giu",
      "last_30_days": "Ultimi 30 giorni",
      "last_7_days": "Ultimi 7 giorni",
      "last_name_required": "Il campo Cognome \xE8 obbligatorio.",
      "last_week": "Settimana scorsa",
      "loading": "Caricamento...",
      "location_field_required": "Il campo posizione \xE8 obbligatorio",
      "logo_field_required": "Il campo del logo del biglietto da visita \xE8 obbligatorio",
      "logo_image_error": "Le dimensioni dellimmagine devono essere 150x150 pixel o meno.",
      "manual_payment_guide": "Guida al pagamento manuale",
      "mar": "Mar",
      "may": "Mag",
      "mon": "LUN",
      "month": "Mese",
      "multi_templates": "Sono richiesti multipli template",
      "next": "Avanti",
      "nfc_card": "Carta NFC",
      "nfc_order": "Ordine NFC",
      "no": "No",
      "nov": "Nov",
      "occupation_field_required": "Il campo occupazione \xE8 obbligatorio",
      "oct": "Ott",
      "ok": "Ok",
      "onesignal_app_id": "Il campo ID App Onesignal \xE8 obbligatorio.",
      "onesignal_rest_api_key": "Il campo Chiave API REST Onesignal \xE8 obbligatorio.",
      "order_placed": "Il tuo ordine \xE8 stato effettuato con successo!",
      "password_character": "La password deve contenere almeno 8 caratteri.",
      "password_must_match": "La password e la conferma della password devono corrispondere.",
      "passwords": "Il campo Password \xE8 obbligatorio.",
      "payment_not_complete": "Pagamento non completato",
      "paypal_key": "Il campo ID Cliente Paypal \xE8 obbligatorio.",
      "paypal_mode": "Il campo Modalit\xE0 Paypal \xE8 obbligatorio.",
      "paypal_secret": "Il campo Segreto Paypal \xE8 obbligatorio.",
      "paystack_key": "Il campo Chiave Paystack \xE8 obbligatorio.",
      "paystack_secret": "Il campo Segreto Paystack \xE8 obbligatorio.",
      "phone": "Telefono",
      "phone_number_required": "Il campo Numero di telefono \xE8 obbligatorio.",
      "phonepe_env_required": "Il campo Ambiente di Phonepe \xE8 obbligatorio.",
      "phonepe_merchant_id_required": "Il campo ID commerciante di Phonepe \xE8 obbligatorio.",
      "phonepe_merchant_transaction_id_required": "Il campo ID transazione commerciante di Phonepe \xE8 obbligatorio.",
      "phonepe_merchant_user_id_required": "Il campo ID utente commerciante di Phonepe \xE8 obbligatorio.",
      "phonepe_salt_index_required": "Il campo Indice di Salt di Phonepe \xE8 obbligatorio.",
      "phonepe_salt_key_required": "Il campo Chiave di Salt di Phonepe \xE8 obbligatorio.",
      "plan": "Piano",
      "plan_expire_notification": "Il campo Notifica scadenza piano \xE8 obbligatorio.",
      "please_select_user": "Per favore, seleziona un utente",
      "please_wait": "Attendere prego...",
      "privacy_policy": "Informativa sulla privacy",
      "product": "Prodotto",
      "product_added_to_cart": "Il prodotto \xE8 stato aggiunto al tuo carrello con successo!",
      "product_category": "Categoria di prodotto",
      "product_deleted_from_cart": "Il prodotto \xE8 stato rimosso dal tuo carrello con successo!",
      "provide_valid_wbsite_url": "Inserisci un URL valido",
      "purchase": "Acquisto",
      "razorpay_key": "Il campo Chiave Razorpay \xE8 obbligatorio.",
      "razorpay_secret": "Il campo Segreto Razorpay \xE8 obbligatorio.",
      "rejected": "Rifiutato",
      "remove": "Rimuovi",
      "sat": "SAB",
      "select_all": "Seleziona tutto",
      "select_email_required": "Il campo Invia email \xE8 obbligatorio.",
      "select_hour": "Seleziona Data o Ora",
      "select_one_or_more": "Seleziona uno o pi\xF9 Elementi richiesti",
      "select_payment_type": "Seleziona Tipo di Pagamento",
      "select_user": "Seleziona utente",
      "select_vcard": "Seleziona VCard",
      "send_email_description": "Descrizione",
      "sep": "Set",
      "short_description": "Inserisci una breve descrizione",
      "skip": "Salta",
      "social_links_img_is_required": "\xC8 necessaria un'immagine dei link social.",
      "social_links_is_required": "I link social sono obbligatori.",
      "state": "Stato",
      "stripe_key": "Il campo chiave di Stripe \xE8 obbligatorio.",
      "stripe_secret": "Il campo Segreto Stripe \xE8 obbligatorio.",
      "subject_required": "Il campo Oggetto \xE8 obbligatorio.",
      "subscriptions": "Abbonamenti",
      "successful": "Successo",
      "sun": "DOM",
      "term_condition": "Termini e condizioni",
      "testimonial": "Testimoniale",
      "the_term_conditions": "I Termini e condizioni sono obbligatori.",
      "this_is_analytics_chart": "Questo \xE8 il tuo grafico di analisi VCard.",
      "this_month": "Questo mese",
      "this_week": "Questa settimana",
      "thu": "GIO",
      "to": "A",
      "today": "Oggi",
      "too_long": "Troppo lungo",
      "too_short": "Troppo corto",
      "tue": "MAR",
      "unavailable": "Non disponibile",
      "upload_required": "Il campo di caricamento del file \xE8 obbligatorio.",
      "user": "Utente",
      "vcard": "VCard",
      "vcard_iframe": "Iframe di VCard",
      "vcard_name": "Nome VCard",
      "vcard_name_required": "Il campo nome del biglietto da visita \xE8 obbligatorio",
      "vcard_service": "Servizio VCard",
      "vcard_testimonial": "Testimonianza VCard",
      "website_field_required": "Il campo sito web \xE8 obbligatorio",
      "wed": "MER",
      "whatsapp_store": "Negozio WhatsApp",
      "yes": "S\xEC",
      "yesterday": "Ieri"
    },
    "pt.js": {
      "Yes_Change": "Sim, Aprovar",
      "add_on": "Adicionar",
      "address_field": "O campo de Endere\xE7o \xE9 obrigat\xF3rio.",
      "admin": "Admin",
      "affiliation_amount_error": "O valor da filia\xE7\xE3o n\xE3o pode exceder 100%",
      "affiliation_email_send": "E-mail de convite enviado com sucesso!",
      "agree_term": "Voc\xEA deve concordar com os Termos e Condi\xE7\xF5es.",
      "allowed_file_types": "Tipos de arquivo permitidos: png, jpg, jpeg.",
      "allowed_image": "Tipos de arquivo permitidos: png, jpg, jpeg.",
      "amount": "Quantidade",
      "app_name_required": "O campo Nome do Aplicativo \xE9 obrigat\xF3rio",
      "apply": "Aplicar",
      "appointment": "Compromisso",
      "appointments": "Compromissos",
      "approved": "Aprovado",
      "apr": "Abr",
      "are_you_completed": "Voc\xEA tem certeza de que deseja aprovar isso?",
      "are_you_sure": "Tem certeza de que deseja excluir isso",
      "are_you_sure_dublicate_vcard": "Tem certeza de que deseja criar uma duplicata deste VCard?",
      "aug": "Ago",
      "back_image_field_required": "Campo da imagem de fundo \xE9 obrigat\xF3rio",
      "blog": "Blog",
      "blog_description": "Descri\xE7\xE3o",
      "blog_image_required": "O campo de imagem do blog \xE9 obrigat\xF3rio.",
      "cancel": "Cancelar",
      "check_email": "E-mail j\xE1 existe.",
      "choose_one_template": "Escolha qualquer modelo",
      "choose_plan": "Escolha o Plano",
      "city": "Cidade",
      "click_open_sidebar": "Clique em Pr\xF3ximo para abrir a barra lateral.",
      "click_to_add_vcard_name": "Clique aqui para adicionar o nome do seu cart\xF5es.",
      "click_to_create_vcards": "Clique em Pr\xF3ximo para criar seu cart\xF5es.",
      "click_to_generate_alias": "Clique aqui para gerar seu alias de URL.",
      "click_to_go_dashboard": "Clique em Pr\xF3ximo para prosseguir para o painel.",
      "click_to_make_vcards": "Clique em Pr\xF3ximo para criar novos cart\xF5es.",
      "click_to_open_edit_sidebar": "Clique em Pr\xF3ximo para acessar a barra lateral de edi\xE7\xE3o do cart\xF5es.",
      "click_to_preview": "Clique aqui para visualizar seu cart\xF5es.",
      "click_to_save_vcard": "Clique em Pr\xF3ximo para salvar seu cart\xF5es.",
      "completed": "Conclu\xEDdo",
      "copied_successfully": "Link copiado com sucesso.",
      "country": "Pa\xEDs",
      "coupon_code": "C\xF3digos de Cupom",
      "coupon_code_apply": "C\xF3digo do cupom aplicado com sucesso.",
      "coupon_code_percent_validation": "O desconto do cupom n\xE3o deve ser superior a 100%.",
      "custom": "Personalizado",
      "custom_link": "Link Personalizado",
      "dec": "Dez",
      "delete": "Excluir",
      "deleted": "Exclu\xEDdo",
      "description": "Insira uma descri\xE7\xE3o do seu cart\xE3o",
      "description_length": "A descri\xE7\xE3o deve ter pelo menos 3 caracteres.",
      "description_required": "O campo Descri\xE7\xE3o \xE9 obrigat\xF3rio.",
      "duplicate": "Duplicar!",
      "duplicate_vcard": "cart\xF5es Duplicado!",
      "duplicate_vcard_create": "cart\xF5es duplicado criado com sucesso",
      "email": "E-mail",
      "email_required": "O campo e-mail \xE9 obrigat\xF3rio",
      "embedtag": "Incorporar etiqueta",
      "enquiry": "Consulta",
      "enter_valid_email": "Por favor, insira um e-mail v\xE1lido.",
      "enter_vcard_name": "Por favor insira um nome cart\xF5es",
      "error": "Erro",
      "faqs": "FAQs",
      "feb": "Fev",
      "first_name_required": "O campo Nome \xE9 obrigat\xF3rio.",
      "flat": "Fixo",
      "flutterwave_key": "O campo de chave Flutterwave \xE9 obrigat\xF3rio.",
      "flutterwave_secret": "O campo de segredo Flutterwave \xE9 obrigat\xF3rio.",
      "fri": "SEX",
      "from": "De",
      "front_image_field_required": "Campo da imagem frontal \xE9 obrigat\xF3rio",
      "gallery": "Galeria",
      "generate_url_alias": "Gere um alias de URL",
      "has_been_completed": "foi conclu\xEDdo.",
      "has_been_deleted": "foi exclu\xEDdo.",
      "here_select_vcard_template": "Aqui voc\xEA pode selecionar seu modelo cart\xF5es.",
      "image_too_large": "Seu arquivo \xE9 muito grande. O tamanho m\xE1ximo permitido \xE9 1MB.",
      "in_progress": "Em andamento",
      "inquries": "Investiga\xE7\xE3o",
      "invalid_country_code": "C\xF3digo de pa\xEDs inv\xE1lido",
      "invalid_email": "O e-mail \xE9 inv\xE1lido",
      "invalid_number": "N\xFAmero inv\xE1lido",
      "jan": "Jan",
      "jul": "Jul",
      "jun": "Jun",
      "last_30_days": "\xDAltimos 30 dias",
      "last_7_days": "\xDAltimos 7 dias",
      "last_name_required": "O campo Sobrenome \xE9 obrigat\xF3rio.",
      "last_week": "Semana Passada",
      "loading": "Carregando...",
      "location_field_required": "Campo de localiza\xE7\xE3o \xE9 obrigat\xF3rio",
      "logo_field_required": "Campo do logotipo do cart\xE3o \xE9 obrigat\xF3rio",
      "logo_image_error": "As dimens\xF5es da imagem devem ser 150x150 pixels ou menos.",
      "manual_payment_guide": "Guia de Pagamento Manual",
      "mar": "Mar",
      "may": "Mai",
      "mon": "SEG",
      "month": "M\xEAs",
      "multi_templates": "M\xFAltiplos modelos s\xE3o necess\xE1rios",
      "next": "Pr\xF3xima",
      "nfc_card": "Cart\xE3o NFC",
      "nfc_order": "Ordem NFC",
      "no": "N\xE3o",
      "nov": "Nov",
      "occupation_field_required": "Campo de ocupa\xE7\xE3o \xE9 obrigat\xF3rio",
      "oct": "Out",
      "ok": "Ok",
      "onesignal_app_id": "O campo de ID do aplicativo do OneSignal \xE9 obrigat\xF3rio.",
      "onesignal_rest_api_key": "O campo da chave de API REST do OneSignal \xE9 obrigat\xF3rio.",
      "order_placed": "Seu pedido foi realizado com sucesso!",
      "password_character": "A senha deve ter pelo menos 8 caracteres.",
      "password_must_match": "A senha e a confirma\xE7\xE3o da senha devem ser iguais.",
      "passwords": "O campo Senhas \xE9 obrigat\xF3rio.",
      "payment_not_complete": "Pagamento n\xE3o conclu\xEDdo",
      "paypal_key": "O campo ID do cliente Paypal \xE9 obrigat\xF3rio.",
      "paypal_mode": "O campo Modo do Paypal \xE9 obrigat\xF3rio.",
      "paypal_secret": "O campo Segredo do Paypal \xE9 obrigat\xF3rio.",
      "paystack_key": "O campo de chave Paystack \xE9 obrigat\xF3rio.",
      "paystack_secret": "O campo de segredo Paystack \xE9 obrigat\xF3rio.",
      "phone": "Telefone",
      "phone_number_required": "O campo N\xFAmero de Telefone \xE9 obrigat\xF3rio.",
      "phonepe_env_required": "O campo Phonepe Env \xE9 obrigat\xF3rio.",
      "phonepe_merchant_id_required": "O campo ID do comerciante do Phonepe \xE9 obrigat\xF3rio.",
      "phonepe_merchant_transaction_id_required": "O campo ID de transa\xE7\xE3o do comerciante do Phonepe \xE9 obrigat\xF3rio.",
      "phonepe_merchant_user_id_required": "O campo ID do usu\xE1rio do comerciante do Phonepe \xE9 obrigat\xF3rio.",
      "phonepe_salt_index_required": "O campo \xCDndice de Sal do Phonepe \xE9 obrigat\xF3rio.",
      "phonepe_salt_key_required": "O campo Chave de Sal do Phonepe \xE9 obrigat\xF3rio.",
      "plan": "Plano",
      "plan_expire_notification": "O campo de Notifica\xE7\xE3o de Expira\xE7\xE3o do Plano \xE9 obrigat\xF3rio.",
      "please_select_user": "Por favor, selecione um usu\xE1rio",
      "please_wait": "Por favor, aguarde...",
      "privacy_policy": "Pol\xEDtica de Privacidade",
      "product": "Produto",
      "product_added_to_cart": "O produto foi adicionado ao seu carrinho com sucesso!",
      "product_category": "Categoria de produto",
      "product_deleted_from_cart": "O produto foi removido do seu carrinho com sucesso!",
      "provide_valid_wbsite_url": "Insira uma URL v\xE1lida",
      "purchase": "Compra",
      "razorpay_key": "O campo-chave Rozorpay \xE9 obrigat\xF3rio.",
      "razorpay_secret": "O campo Rozorpay Secret \xE9 obrigat\xF3rio.",
      "rejected": "Rejeitado",
      "remove": "Remover",
      "sat": "S\xC1B",
      "select_all": "Selecionar tudo",
      "select_email_required": "O campo Enviar e-mail \xE9 obrigat\xF3rio.",
      "select_hour": "Por favor, selecione Data ou Hora",
      "select_one_or_more": "Selecione uma ou mais caracter\xEDsticas s\xE3o necess\xE1rias",
      "select_payment_type": "Selecione o tipo de pagamento",
      "select_user": "Selecionar usu\xE1rio",
      "select_vcard": "Selecione Vcard",
      "send_email_description": "Descri\xE7\xE3o",
      "sep": "Set",
      "short_description": "Digite uma descri\xE7\xE3o curta",
      "skip": "Pular",
      "social_links_img_is_required": "A imagem dos links sociais \xE9 obrigat\xF3ria.",
      "social_links_is_required": "Links sociais s\xE3o obrigat\xF3rios.",
      "state": "Estado",
      "stripe_key": "O campo de chave Stripe \xE9 obrigat\xF3rio.",
      "stripe_secret": "O campo Segredo do Stripe \xE9 obrigat\xF3rio.",
      "subject_required": "O campo assunto \xE9 obrigat\xF3rio.",
      "subscriptions": "Assinaturas",
      "successful": "Bem-sucedido",
      "sun": "DOM",
      "term_condition": "Termos e Condi\xE7\xF5es",
      "testimonial": "Depoimento",
      "the_term_conditions": "Os Termos e Condi\xE7\xF5es s\xE3o obrigat\xF3rios.",
      "this_is_analytics_chart": "Este \xE9 o seu gr\xE1fico anal\xEDtico do cart\xF5es.",
      "this_month": "Este m\xEAs",
      "this_week": "Esta Semana",
      "thu": "QUI",
      "to": "Para",
      "today": "Hoje",
      "too_long": "Muito longo",
      "too_short": "Muito curto",
      "tue": "TER",
      "unavailable": "Indispon\xEDvel",
      "upload_required": "O campo de upload de arquivo \xE9 obrigat\xF3rio.",
      "user": "Usu\xE1rio",
      "vcard": "VCard",
      "vcard_iframe": "Iframe do VCard",
      "vcard_name": "Nome do VCard",
      "vcard_name_required": "Campo de nome do cart\xE3o \xE9 obrigat\xF3rio",
      "vcard_service": "Servi\xE7o VCard",
      "vcard_testimonial": "Depoimento VCard",
      "website_field_required": "Campo do site \xE9 obrigat\xF3rio",
      "wed": "QUA",
      "whatsapp_store": "Loja do WhatsApp",
      "yes": "Sim",
      "yesterday": "Ontem"
    },
    "ru.js": {
      "Yes_Change": "\u0414\u0430, \u041E\u0434\u043E\u0431\u0440\u0438\u0442\u044C",
      "add_on": "\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C",
      "address_field": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u043F\u043E\u043B\u0435 \"\u0410\u0434\u0440\u0435\u0441\".",
      "admin": "\u0410\u0434\u043C\u0438\u043D\u0438\u0441\u0442\u0440\u0430\u0442\u043E\u0440",
      "affiliation_amount_error": "\u0421\u0443\u043C\u043C\u0430 \u0430\u0444\u0444\u0438\u043B\u0438\u0430\u0446\u0438\u0438 \u043D\u0435 \u043C\u043E\u0436\u0435\u0442 \u043F\u0440\u0435\u0432\u044B\u0448\u0430\u0442\u044C 100%",
      "affiliation_email_send": "\u041F\u0440\u0438\u0433\u043B\u0430\u0448\u0435\u043D\u0438\u0435 \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u043E\u0442\u043F\u0440\u0430\u0432\u043B\u0435\u043D\u043E!",
      "agree_term": "\u0412\u044B \u0434\u043E\u043B\u0436\u043D\u044B \u0441\u043E\u0433\u043B\u0430\u0441\u0438\u0442\u044C\u0441\u044F \u0441 \u0443\u0441\u043B\u043E\u0432\u0438\u044F\u043C\u0438.",
      "allowed_file_types": "\u0414\u043E\u043F\u0443\u0441\u0442\u0438\u043C\u044B\u0435 \u0442\u0438\u043F\u044B \u0444\u0430\u0439\u043B\u043E\u0432: png, jpg, jpeg.",
      "allowed_image": "\u0414\u043E\u043F\u0443\u0441\u0442\u0438\u043C\u044B\u0435 \u0442\u0438\u043F\u044B \u0444\u0430\u0439\u043B\u043E\u0432: png, jpg, jpeg.",
      "amount": "\u0421\u0443\u043C\u043C\u0430",
      "app_name_required": "\u041F\u043E\u043B\u0435 \"\u0418\u043C\u044F \u043F\u0440\u0438\u043B\u043E\u0436\u0435\u043D\u0438\u044F\" \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u0434\u043B\u044F \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u044F",
      "apply": "\u041F\u0440\u0438\u043C\u0435\u043D\u0438\u0442\u044C",
      "appointment": "\u0417\u0430\u043F\u0438\u0441\u044C",
      "appointments": "\u0417\u0430\u043F\u0438\u0441\u0438",
      "approved": "\u041E\u0434\u043E\u0431\u0440\u0435\u043D\u043E",
      "apr": "\u0410\u043F\u0440",
      "are_you_completed": "\u0412\u044B \u0443\u0432\u0435\u0440\u0435\u043D\u044B, \u0447\u0442\u043E \u0445\u043E\u0442\u0438\u0442\u0435 \u043E\u0434\u043E\u0431\u0440\u0438\u0442\u044C \u044D\u0442\u043E?",
      "are_you_sure": "\u0412\u044B \u0443\u0432\u0435\u0440\u0435\u043D\u044B, \u0447\u0442\u043E \u0445\u043E\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043B\u0438\u0442\u044C \u044D\u0442\u043E",
      "are_you_sure_dublicate_vcard": "\u0412\u044B \u0443\u0432\u0435\u0440\u0435\u043D\u044B, \u0447\u0442\u043E \u0445\u043E\u0442\u0438\u0442\u0435 \u0441\u043E\u0437\u0434\u0430\u0442\u044C \u0434\u0443\u0431\u043B\u0438\u043A\u0430\u0442 \u044D\u0442\u043E\u0439 \u0432\u0438\u0437\u0438\u0442\u043D\u043E\u0439 \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0438?",
      "aug": "\u0410\u0432\u0433",
      "back_image_field_required": "\u041F\u043E\u043B\u0435 \u0437\u0430\u0434\u043D\u0435\u0433\u043E \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "blog": "\u0411\u043B\u043E\u0433",
      "blog_description": "\u041E\u043F\u0438\u0441\u0430\u043D\u0438\u0435",
      "blog_image_required": "\u041F\u043E\u043B\u0435 \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F \u0431\u043B\u043E\u0433\u0430 \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "cancel": "\u041E\u0442\u043C\u0435\u043D\u0430",
      "check_email": "\u0410\u0434\u0440\u0435\u0441 \u044D\u043B\u0435\u043A\u0442\u0440\u043E\u043D\u043D\u043E\u0439 \u043F\u043E\u0447\u0442\u044B \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.",
      "choose_one_template": "\u0412\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u043B\u044E\u0431\u043E\u0439 \u0448\u0430\u0431\u043B\u043E\u043D",
      "choose_plan": "\u0412\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u043F\u043B\u0430\u043D",
      "city": "\u0413\u043E\u0440\u043E\u0434",
      "click_open_sidebar": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0414\u0430\u043B\u0435\u0435\xBB, \u0447\u0442\u043E\u0431\u044B \u043E\u0442\u043A\u0440\u044B\u0442\u044C \u0431\u043E\u043A\u043E\u0432\u0443\u044E \u043F\u0430\u043D\u0435\u043B\u044C.",
      "click_to_create_vcards": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0414\u0430\u043B\u0435\u0435\xBB, \u0447\u0442\u043E\u0431\u044B \u0441\u043E\u0437\u0434\u0430\u0442\u044C \u0441\u0432\u043E\u044E \u0432\u0438\u0437\u0438\u0442\u043D\u0443\u044E \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0443.",
      "click_to_generate_alias": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \u0437\u0434\u0435\u0441\u044C, \u0447\u0442\u043E\u0431\u044B \u0441\u043E\u0437\u0434\u0430\u0442\u044C \u043F\u0441\u0435\u0432\u0434\u043E\u043D\u0438\u043C URL-\u0430\u0434\u0440\u0435\u0441\u0430.",
      "click_to_go_dashboard": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0414\u0430\u043B\u0435\u0435\xBB, \u0447\u0442\u043E\u0431\u044B \u043F\u0435\u0440\u0435\u0439\u0442\u0438 \u043D\u0430 \u043F\u0430\u043D\u0435\u043B\u044C \u0438\u043D\u0441\u0442\u0440\u0443\u043C\u0435\u043D\u0442\u043E\u0432.",
      "click_to_make_vcards": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0414\u0430\u043B\u0435\u0435\xBB, \u0447\u0442\u043E\u0431\u044B \u0441\u043E\u0437\u0434\u0430\u0442\u044C \u043D\u043E\u0432\u044B\u0435 VCards.",
      "click_to_open_edit_sidebar": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0414\u0430\u043B\u0435\u0435\xBB, \u0447\u0442\u043E\u0431\u044B \u043F\u043E\u043B\u0443\u0447\u0438\u0442\u044C \u0434\u043E\u0441\u0442\u0443\u043F \u043A \u0431\u043E\u043A\u043E\u0432\u043E\u0439 \u043F\u0430\u043D\u0435\u043B\u0438 \u0440\u0435\u0434\u0430\u043A\u0442\u0438\u0440\u043E\u0432\u0430\u043D\u0438\u044F VCard.",
      "click_to_preview": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \u0437\u0434\u0435\u0441\u044C, \u0447\u0442\u043E\u0431\u044B \u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440\u0435\u0442\u044C \u0432\u0430\u0448\u0443 \u0432\u0438\u0437\u0438\u0442\u043D\u0443\u044E \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0443.",
      "click_to_save_vcard": "\u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0414\u0430\u043B\u0435\u0435\xBB, \u0447\u0442\u043E\u0431\u044B \u0441\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C \u043A\u0430\u0440\u0442\u0443 VCard.",
      "completed": "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043D\u043E",
      "copied_successfully": "\u0421\u0441\u044B\u043B\u043A\u0430 \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u0441\u043A\u043E\u043F\u0438\u0440\u043E\u0432\u0430\u043D\u0430.",
      "country": "\u0421\u0442\u0440\u0430\u043D\u0430",
      "coupon_code": "\u041F\u0440\u043E\u043C\u043E\u043A\u043E\u0434\u044B",
      "coupon_code_apply": "\u041F\u0440\u043E\u043C\u043E\u043A\u043E\u0434 \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u043F\u0440\u0438\u043C\u0435\u043D\u0435\u043D.",
      "coupon_code_percent_validation": "\u0421\u043A\u0438\u0434\u043A\u0430 \u043F\u043E \u043A\u0443\u043F\u043E\u043D\u0443 \u043D\u0435 \u0434\u043E\u043B\u0436\u043D\u0430 \u0431\u044B\u0442\u044C \u0431\u043E\u043B\u0435\u0435 100%.",
      "custom": "\u041F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044C\u0441\u043A\u0438\u0439",
      "custom_link": "\u041F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044C\u0441\u043A\u0430\u044F \u0421\u0441\u044B\u043B\u043A\u0430",
      "dec": "\u0414\u0435\u043A",
      "delete": "\u0423\u0434\u0430\u043B\u0438\u0442\u044C",
      "deleted": "\u0423\u0434\u0430\u043B\u0435\u043D\u043E",
      "description": "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043E\u043F\u0438\u0441\u0430\u043D\u0438\u0435 \u0432\u0430\u0448\u0435\u0439 \u0432\u0438\u0437\u0438\u0442\u043D\u043E\u0439 \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0438",
      "description_length": "\u041E\u043F\u0438\u0441\u0430\u043D\u0438\u0435 \u0434\u043E\u043B\u0436\u043D\u043E \u0441\u043E\u0434\u0435\u0440\u0436\u0430\u0442\u044C \u043A\u0430\u043A \u043C\u0438\u043D\u0438\u043C\u0443\u043C 3 \u0441\u0438\u043C\u0432\u043E\u043B\u0430.",
      "description_required": "\u041F\u043E\u043B\u0435 \u043E\u043F\u0438\u0441\u0430\u043D\u0438\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "duplicate": "\u0414\u0443\u0431\u043B\u0438\u043A\u0430\u0442!",
      "duplicate_vcard": "\u0414\u0443\u0431\u043B\u0438\u043A\u0430\u0442 \u0432",
      "duplicate_vcard_create": "\u0414\u0443\u0431\u043B\u0438\u043A\u0430\u0442 \u0432\u0438\u0437\u0438\u0442\u043D\u043E\u0439 \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0438 \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u0441\u043E\u0437\u0434\u0430\u043D",
      "email": "\u042D\u043B\u0435\u043A\u0442\u0440\u043E\u043D\u043D\u0430\u044F \u043F\u043E\u0447\u0442\u0430",
      "email_required": "\u041F\u043E\u043B\u0435 \u044D\u043B\u0435\u043A\u0442\u0440\u043E\u043D\u043D\u043E\u0439 \u043F\u043E\u0447\u0442\u044B \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "embedtag": "\u0412\u0441\u0442\u0440\u043E\u0438\u0442\u044C \u0442\u0435\u0433",
      "enquiry": "\u0417\u0430\u043F\u0440\u043E\u0441",
      "enter_valid_email": "\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043B\u044C\u043D\u044B\u0439 \u0430\u0434\u0440\u0435\u0441 \u044D\u043B\u0435\u043A\u0442\u0440\u043E\u043D\u043D\u043E\u0439 \u043F\u043E\u0447\u0442\u044B.",
      "enter_vcard_name": "\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043C\u044F Vcard",
      "error": "\u041E\u0448\u0438\u0431\u043A\u0430",
      "faqs": "\u0427\u0430\u0441\u0442\u043E \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043C\u044B\u0435 \u0432\u043E\u043F\u0440\u043E\u0441\u044B",
      "feb": "\u0424\u0435\u0432",
      "first_name_required": "\u041F\u043E\u043B\u0435 \"\u0418\u043C\u044F\" \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u0434\u043B\u044F \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u044F.",
      "flat": "\u041F\u043B\u043E\u0441\u043A\u0438\u0439",
      "flutterwave_key": "\u041F\u043E\u043B\u0435 \u043A\u043B\u044E\u0447\u0430 Flutterwave \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "flutterwave_secret": "\u041F\u043E\u043B\u0435 \u0441\u0435\u043A\u0440\u0435\u0442\u0430 Flutterwave \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "fri": "\u041F\u0422",
      "from": "\u041E\u0442",
      "front_image_field_required": "\u041F\u043E\u043B\u0435 \u043F\u0435\u0440\u0435\u0434\u043D\u0435\u0433\u043E \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "gallery": "\u0413\u0430\u043B\u0435\u0440\u0435\u044F",
      "generate_url_alias": "\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u0441\u043E\u0437\u0434\u0430\u0439\u0442\u0435 \u043F\u0441\u0435\u0432\u0434\u043E\u043D\u0438\u043C URL-\u0430\u0434\u0440\u0435\u0441\u0430",
      "has_been_completed": "\u0431\u044B\u043B\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043D\u0430.",
      "has_been_deleted": "\u0431\u044B\u043B\u043E \u0443\u0434\u0430\u043B\u0435\u043D\u043E.",
      "here_select_vcard_template": "\u0417\u0434\u0435\u0441\u044C \u0432\u044B \u043C\u043E\u0436\u0435\u0442\u0435 \u0432\u044B\u0431\u0440\u0430\u0442\u044C \u0448\u0430\u0431\u043B\u043E\u043D VCard.",
      "image_too_large": "\u0412\u0430\u0448 \u0444\u0430\u0439\u043B \u0441\u043B\u0438\u0448\u043A\u043E\u043C \u0432\u0435\u043B\u0438\u043A. \u041C\u0430\u043A\u0441\u0438\u043C\u0430\u043B\u044C\u043D\u043E \u0434\u043E\u043F\u0443\u0441\u0442\u0438\u043C\u044B\u0439 \u0440\u0430\u0437\u043C\u0435\u0440 \u2014 1 \u041C\u0411.",
      "in_progress": "\u0412 \u043F\u0440\u043E\u0446\u0435\u0441\u0441\u0435",
      "inquries": "\u0420\u0430\u0441\u0441\u043B\u0435\u0434\u043E\u0432\u0430\u043D\u0438\u0435",
      "invalid_country_code": "\u041D\u0435\u0434\u043E\u043F\u0443\u0441\u0442\u0438\u043C\u044B\u0439 \u043A\u043E\u0434 \u0441\u0442\u0440\u0430\u043D\u044B",
      "invalid_email": "\u042D\u043B\u0435\u043A\u0442\u0440\u043E\u043D\u043D\u0430\u044F \u043F\u043E\u0447\u0442\u0430 \u043D\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043B\u044C\u043D\u0430",
      "invalid_number": "\u041D\u0435\u0432\u0435\u0440\u043D\u044B\u0439 \u043D\u043E\u043C\u0435\u0440",
      "jan": "\u042F\u043D\u0432",
      "jul": "\u0418\u044E\u043B",
      "jun": "\u0418\u044E\u043D",
      "last_30_days": "\u041F\u043E\u0441\u043B\u0435\u0434\u043D\u0438\u0435 30 \u0434\u043D\u0435\u0439",
      "last_7_days": "\u041F\u043E\u0441\u043B\u0435\u0434\u043D\u0438\u0435 7 \u0434\u043D\u0435\u0439",
      "last_name_required": "\u041F\u043E\u043B\u0435 \"\u0424\u0430\u043C\u0438\u043B\u0438\u044F\" \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u0434\u043B\u044F \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u044F.",
      "last_week": "\u041D\u0430 \u043F\u0440\u043E\u0448\u043B\u043E\u0439 \u043D\u0435\u0434\u0435\u043B\u0435",
      "loading": "\u0417\u0430\u0433\u0440\u0443\u0437\u043A\u0430...",
      "location_field_required": "\u041F\u043E\u043B\u0435 \u043C\u0435\u0441\u0442\u043E\u043F\u043E\u043B\u043E\u0436\u0435\u043D\u0438\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "logo_field_required": "\u041F\u043E\u043B\u0435 \u043B\u043E\u0433\u043E\u0442\u0438\u043F\u0430 \u043A\u0430\u0440\u0442\u044B \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "logo_image_error": "\u0420\u0430\u0437\u043C\u0435\u0440\u044B \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044F \u0434\u043E\u043B\u0436\u043D\u044B \u0431\u044B\u0442\u044C 150x150 \u043F\u0438\u043A\u0441\u0435\u043B\u0435\u0439 \u0438\u043B\u0438 \u043C\u0435\u043D\u044C\u0448\u0435.",
      "manual_payment_guide": "\u0420\u0443\u043A\u043E\u0432\u043E\u0434\u0441\u0442\u0432\u043E \u043F\u043E \u0440\u0443\u0447\u043D\u043E\u0439 \u043E\u043F\u043B\u0430\u0442\u0435",
      "mar": "\u041C\u0430\u0440",
      "may": "\u041C\u0430\u0439",
      "mon": "\u041F\u041D",
      "month": "\u041C\u0435\u0441\u044F\u0446",
      "multi_templates": "\u0422\u0440\u0435\u0431\u0443\u044E\u0442\u0441\u044F \u043D\u0435\u0441\u043A\u043E\u043B\u044C\u043A\u043E \u0448\u0430\u0431\u043B\u043E\u043D\u043E\u0432",
      "next": "\u0421\u043B\u0435\u0434\u0443\u044E\u0449\u0438\u0439",
      "nfc_card": "NFC \u041A\u0430\u0440\u0442\u0430",
      "nfc_order": "NFC-\u0437\u0430\u043A\u0430\u0437",
      "no": "\u041D\u0435\u0442",
      "nov": "\u041D\u043E\u044F",
      "occupation_field_required": "\u041F\u043E\u043B\u0435 \u043F\u0440\u043E\u0444\u0435\u0441\u0441\u0438\u0438 \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "oct": "\u041E\u043A\u0442",
      "ok": "\u041E\u043A",
      "onesignal_app_id": "\u041F\u043E\u043B\u0435 ID \u043F\u0440\u0438\u043B\u043E\u0436\u0435\u043D\u0438\u044F OneSignal \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u0434\u043B\u044F \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u044F.",
      "onesignal_rest_api_key": "\u041F\u043E\u043B\u0435 \u043A\u043B\u044E\u0447\u0430 REST API OneSignal \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u0434\u043B\u044F \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u044F.",
      "order_placed": "\u0412\u0430\u0448 \u0437\u0430\u043A\u0430\u0437 \u0431\u044B\u043B \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u043E\u0444\u043E\u0440\u043C\u043B\u0435\u043D!",
      "password_character": "\u041F\u0430\u0440\u043E\u043B\u044C \u0434\u043E\u043B\u0436\u0435\u043D \u0441\u043E\u0434\u0435\u0440\u0436\u0430\u0442\u044C \u043D\u0435 \u043C\u0435\u043D\u0435\u0435 8 \u0441\u0438\u043C\u0432\u043E\u043B\u043E\u0432.",
      "password_must_match": "\u041F\u0430\u0440\u043E\u043B\u044C \u0438 \u043F\u043E\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043D\u0438\u0435 \u043F\u0430\u0440\u043E\u043B\u044F \u0434\u043E\u043B\u0436\u043D\u044B \u0441\u043E\u0432\u043F\u0430\u0434\u0430\u0442\u044C.",
      "passwords": "\u041F\u043E\u043B\u0435 \"\u041F\u0430\u0440\u043E\u043B\u0438\" \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u0434\u043B\u044F \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u044F.",
      "payment_not_complete": "\u041E\u043F\u043B\u0430\u0442\u0430 \u043D\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043D\u0430",
      "paypal_key": "\u041F\u043E\u043B\u0435 \u0438\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u0430 \u043A\u043B\u0438\u0435\u043D\u0442\u0430 PayPal \u044F\u0432\u043B\u044F\u0435\u0442\u0441\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u044B\u043C.",
      "paypal_mode": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u0440\u0435\u0436\u0438\u043C PayPal.",
      "paypal_secret": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u0441\u0435\u043A\u0440\u0435\u0442\u043D\u044B\u0439 \u043A\u043B\u044E\u0447 PayPal.",
      "paystack_key": "\u041F\u043E\u043B\u0435 \u043A\u043B\u044E\u0447\u0430 Paystack \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "paystack_secret": "\u041F\u043E\u043B\u0435 \u0441\u0435\u043A\u0440\u0435\u0442\u0430 Paystack \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "phone": "\u0422\u0435\u043B\u0435\u0444\u043E\u043D",
      "phone_number_required": "\u041F\u043E\u043B\u0435 \"\u041D\u043E\u043C\u0435\u0440 \u0442\u0435\u043B\u0435\u0444\u043E\u043D\u0430\" \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E \u0434\u043B\u044F \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u044F.",
      "phonepe_env_required": "\u041F\u043E\u043B\u0435 Phonepe Env \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "phonepe_merchant_id_required": "\u041F\u043E\u043B\u0435 \u0438\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u0430 \u0442\u043E\u0440\u0433\u043E\u0432\u0446\u0430 Phonepe \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "phonepe_merchant_transaction_id_required": "\u041F\u043E\u043B\u0435 \u0438\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u0430 \u0442\u0440\u0430\u043D\u0437\u0430\u043A\u0446\u0438\u0438 \u0442\u043E\u0440\u0433\u043E\u0432\u0446\u0430 Phonepe \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "phonepe_merchant_user_id_required": "\u041F\u043E\u043B\u0435 \u0438\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u0430 \u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044F \u0442\u043E\u0440\u0433\u043E\u0432\u0446\u0430 Phonepe \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "phonepe_salt_index_required": "\u041F\u043E\u043B\u0435 \u0438\u043D\u0434\u0435\u043A\u0441\u0430 \u0441\u043E\u043B\u0438 Phonepe \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "phonepe_salt_key_required": "\u041F\u043E\u043B\u0435 \u043A\u043B\u044E\u0447\u0430 \u0441\u043E\u043B\u0438 Phonepe \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "plan": "\u041F\u043B\u0430\u043D",
      "plan_expire_notification": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u0443\u0432\u0435\u0434\u043E\u043C\u043B\u0435\u043D\u0438\u0435 \u043E \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043D\u0438\u0438 \u0441\u0440\u043E\u043A\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044F \u043F\u043B\u0430\u043D\u0430.",
      "please_select_user": "\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u0432\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044F",
      "please_wait": "\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u043F\u043E\u0434\u043E\u0436\u0434\u0438\u0442\u0435...",
      "privacy_policy": "\u041F\u043E\u043B\u0438\u0442\u0438\u043A\u0430 \u043A\u043E\u043D\u0444\u0438\u0434\u0435\u043D\u0446\u0438\u0430\u043B\u044C\u043D\u043E\u0441\u0442\u0438",
      "product": "\u041F\u0440\u043E\u0434\u0443\u043A\u0442",
      "product_added_to_cart": "\u0422\u043E\u0432\u0430\u0440 \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u0434\u043E\u0431\u0430\u0432\u043B\u0435\u043D \u0432 \u0432\u0430\u0448\u0443 \u043A\u043E\u0440\u0437\u0438\u043D\u0443!",
      "product_category": "\u041A\u0430\u0442\u0435\u0433\u043E\u0440\u0438\u044F \u043F\u0440\u043E\u0434\u0443\u043A\u0442\u0430",
      "product_deleted_from_cart": "\u0422\u043E\u0432\u0430\u0440 \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u0443\u0434\u0430\u043B\u0435\u043D \u0438\u0437 \u0432\u0430\u0448\u0435\u0439 \u043A\u043E\u0440\u0437\u0438\u043D\u044B!",
      "provide_valid_wbsite_url": "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043B\u044C\u043D\u044B\u0439 URL",
      "purchase": "\u041F\u043E\u043A\u0443\u043F\u043A\u0430",
      "razorpay_key": "\u041A\u043B\u044E\u0447\u0435\u0432\u043E\u0435 \u043F\u043E\u043B\u0435 Rozorpay \u044F\u0432\u043B\u044F\u0435\u0442\u0441\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u044B\u043C.",
      "razorpay_secret": "\u041F\u043E\u043B\u0435 Rozorpay Secret \u044F\u0432\u043B\u044F\u0435\u0442\u0441\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u044B\u043C.",
      "rejected": "\u041E\u0442\u043A\u043B\u043E\u043D\u0435\u043D\u043E",
      "remove": "\u0423\u0434\u0430\u043B\u0438\u0442\u044C",
      "sat": "\u0421\u0411",
      "select_all": "\u0412\u044B\u0431\u0440\u0430\u0442\u044C \u0432\u0441\u0435",
      "select_email_required": "\u041F\u043E\u043B\u0435 \xAB\u041E\u0442\u043F\u0440\u0430\u0432\u0438\u0442\u044C \u043F\u043E\u0447\u0442\u0443\xBB \u044F\u0432\u043B\u044F\u0435\u0442\u0441\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u044B\u043C.",
      "select_hour": "\u041F\u043E\u0436\u0430\u043B\u0443\u0439\u0441\u0442\u0430, \u0432\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0438\u043B\u0438 \u0447\u0430\u0441",
      "select_one_or_more": "\u0412\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u043E\u0434\u043D\u0443 \u0438\u043B\u0438 \u043D\u0435\u0441\u043A\u043E\u043B\u044C\u043A\u043E \u0444\u0443\u043D\u043A\u0446\u0438\u0439",
      "select_payment_type": "\u0412\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043F \u043F\u043B\u0430\u0442\u0435\u0436\u0430",
      "select_user": "\u0412\u044B\u0431\u0440\u0430\u0442\u044C \u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044F",
      "select_vcard": "\u0412\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0438\u0437\u0438\u0442\u043D\u0443\u044E \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0443",
      "send_email_description": "\u041E\u043F\u0438\u0441\u0430\u043D\u0438\u0435",
      "sep": "\u0421\u0435\u043D",
      "short_description": "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043A\u0440\u0430\u0442\u043A\u043E\u0435 \u043E\u043F\u0438\u0441\u0430\u043D\u0438\u0435",
      "skip": "\u041F\u0440\u043E\u043F\u0443\u0441\u043A\u0430\u0442\u044C",
      "social_links_img_is_required": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435 \u0441\u043E\u0446\u0438\u0430\u043B\u044C\u043D\u044B\u0445 \u0441\u0441\u044B\u043B\u043E\u043A.",
      "social_links_is_required": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u0443\u043A\u0430\u0437\u0430\u0442\u044C \u0441\u043E\u0446\u0438\u0430\u043B\u044C\u043D\u044B\u0435 \u0441\u0441\u044B\u043B\u043A\u0438.",
      "state": "\u0428\u0442\u0430\u0442",
      "stripe_key": "\u041F\u043E\u043B\u0435 \u043A\u043B\u044E\u0447\u0430 Stripe \u044F\u0432\u043B\u044F\u0435\u0442\u0441\u044F \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u044B\u043C.",
      "stripe_secret": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u0441\u0435\u043A\u0440\u0435\u0442\u043D\u044B\u0439 \u043A\u043B\u044E\u0447 Stripe.",
      "subject_required": "\u041F\u043E\u043B\u0435 \u0422\u0435\u043C\u0430 \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E.",
      "subscriptions": "\u041F\u043E\u0434\u043F\u0438\u0441\u043A\u0438",
      "successful": "\u0423\u0441\u043F\u0435\u0448\u043D\u043E",
      "sun": "\u0412\u0421",
      "term_condition": "\u0423\u0441\u043B\u043E\u0432\u0438\u044F \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u043D\u0438\u044F",
      "testimonial": "\u041E\u0442\u0437\u044B\u0432",
      "the_term_conditions": "\u0422\u0440\u0435\u0431\u0443\u044E\u0442\u0441\u044F \u0443\u0441\u043B\u043E\u0432\u0438\u044F \u0438\u0441\u043F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u043D\u0438\u044F.",
      "this_is_analytics_chart": "\u042D\u0442\u043E \u0432\u0430\u0448\u0430 \u0430\u043D\u0430\u043B\u0438\u0442\u0438\u0447\u0435\u0441\u043A\u0430\u044F \u0434\u0438\u0430\u0433\u0440\u0430\u043C\u043C\u0430 VCard.",
      "this_month": "\u042D\u0442\u043E\u0442 \u043C\u0435\u0441\u044F\u0446",
      "this_week": "\u041D\u0430 \u044D\u0442\u043E\u0439 \u043D\u0435\u0434\u0435\u043B\u0435",
      "thu": "\u0427\u0422",
      "to": "\u0414\u043E",
      "today": "\u0421\u0435\u0433\u043E\u0434\u043D\u044F",
      "too_long": "\u0421\u043B\u0438\u0448\u043A\u043E\u043C \u0434\u043B\u0438\u043D\u043D\u043E\u0435",
      "too_short": "\u0421\u043B\u0438\u0448\u043A\u043E\u043C \u043A\u043E\u0440\u043E\u0442\u043A\u043E\u0435",
      "tue": "\u0412\u0422",
      "unavailable": "\u041D\u0435\u0434\u043E\u0441\u0442\u0443\u043F\u043D\u043E",
      "upload_required": "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F \u043F\u043E\u043B\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043A\u0438 \u0444\u0430\u0439\u043B\u0430.",
      "user": "\u041F\u043E\u043B\u044C\u0437\u043E\u0432\u0430\u0442\u0435\u043B\u044C",
      "vcard": "\u0412\u0438\u0437\u0438\u0442\u043A\u0430",
      "vcard_iframe": "Iframe VCard",
      "vcard_name": "\u0418\u043C\u044F \u0432\u0438\u0437\u0438\u0442\u043D\u043E\u0439 \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0438",
      "vcard_name_required": "\u041F\u043E\u043B\u0435 \u0438\u043C\u0435\u043D\u0438 \u0432\u0438\u0437\u0438\u0442\u043A\u0438 \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "vcard_service": "\u0421\u0435\u0440\u0432\u0438\u0441 VCard",
      "vcard_testimonial": "\u041E\u0442\u0437\u044B\u0432 VCard",
      "website_field_required": "\u041F\u043E\u043B\u0435 \u0432\u0435\u0431-\u0441\u0430\u0439\u0442\u0430 \u043E\u0431\u044F\u0437\u0430\u0442\u0435\u043B\u044C\u043D\u043E",
      "wed": "\u0421\u0420",
      "whatsapp_store": "\u041C\u0430\u0433\u0430\u0437\u0438\u043D WhatsApp",
      "yes": "\u0414\u0430",
      "yesterday": "\u0412\u0447\u0435\u0440\u0430"
    },
    "tr.js": {
      "Yes_Change": "Evet, Onayla",
      "add_on": "Ayriyeten",
      "address_field": "Adres Alan\u0131 alan\u0131 gereklidir.",
      "admin": "Y\xF6netici",
      "affiliation_amount_error": "Ba\u011Fl\u0131l\u0131k tutar\u0131 100%'den fazla olamaz",
      "affiliation_email_send": "Davetiye e-postas\u0131 ba\u015Far\u0131yla g\xF6nderildi!",
      "agree_term": "\u015Eartlar ve ko\u015Fullar\u0131 kabul etmelisiniz.",
      "allowed_file_types": "\u0130zin verilen dosya t\xFCrleri: png, jpg, jpeg.",
      "allowed_image": "\u0130zin verilen dosya t\xFCrleri: png, jpg, jpeg.",
      "amount": "Tutar",
      "app_name_required": "Uygulama Ad\u0131 alan\u0131 gereklidir",
      "apply": "Uygula",
      "appointment": "Randevu",
      "appointments": "Randevular",
      "approved": "Onayland\u0131",
      "apr": "Nis",
      "are_you_completed": "Emin misiniz, bunu onaylamak istiyor musunuz?",
      "are_you_sure": "Bunu silmek istedi\u011Finizden emin misiniz",
      "are_you_sure_dublicate_vcard": "Bu VCard'\u0131 \xE7o\u011Faltmak istedi\u011Finizden emin misiniz?",
      "aug": "A\u011Fu",
      "back_image_field_required": "Arka resim alan\u0131 gereklidir",
      "blog": "Blog",
      "blog_description": "Tan\u0131m",
      "blog_image_required": "Blog g\xF6rseli alan\u0131 zorunludur.",
      "cancel": "\u0130ptal",
      "check_email": "Bu e-posta zaten var.",
      "choose_one_template": "Herhangi bir \u015Fablonu se\xE7in",
      "choose_plan": "Plan Se\xE7",
      "city": "\u015Eehir",
      "click_open_sidebar": "Kenar \xC7ubu\u011Funu A\xE7mak i\xE7in \u0130leri'ye t\u0131klay\u0131n.",
      "click_to_create_vcards": "VCard'\u0131n\u0131z\u0131 Olu\u015Fturmak i\xE7in \u0130leri'ye t\u0131klay\u0131n.",
      "click_to_generate_alias": "URL Takma Ad\u0131n\u0131z\u0131 Olu\u015Fturmak i\xE7in Buraya T\u0131klay\u0131n.",
      "click_to_go_dashboard": "Kontrol Paneline Devam etmek i\xE7in \u0130leri'ye t\u0131klay\u0131n.",
      "click_to_make_vcards": "Yeni VCard'lar Olu\u015Fturmak i\xE7in \u0130leri'ye t\u0131klay\u0131n.",
      "click_to_open_edit_sidebar": "VCard D\xFCzenleme Kenar \xC7ubu\u011Funa Eri\u015Fmek \u0130\xE7in \u0130leri'ye t\u0131klay\u0131n.",
      "click_to_preview": "VCard'\u0131n\u0131z\u0131 \xD6nizlemek \u0130\xE7in Buraya T\u0131klay\u0131n.",
      "click_to_save_vcard": "VCard'\u0131n\u0131z\u0131 Kaydetmek i\xE7in \u0130leri'ye t\u0131klay\u0131n.",
      "completed": "Tamamland\u0131",
      "copied_successfully": "Ba\u011Flant\u0131 ba\u015Far\u0131yla kopyaland\u0131.",
      "country": "\xDClke",
      "coupon_code": "Kupon Kodlar\u0131",
      "coupon_code_apply": "Kupon Kodu ba\u015Far\u0131yla uyguland\u0131.",
      "coupon_code_percent_validation": "Kupon indirimi %100'den fazla olmamal\u0131d\u0131r.",
      "custom": "\xD6zel",
      "custom_link": "\xD6zel Ba\u011Flant\u0131",
      "dec": "Ara",
      "delete": "Sil",
      "deleted": "Silindi",
      "description": "VCard'\u0131n\u0131z\u0131n A\xE7\u0131klamas\u0131n\u0131 Girin",
      "description_length": "A\xE7\u0131klama en az 3 karakter olmal\u0131d\u0131r.",
      "description_required": "A\xE7\u0131klama alan\u0131 zorunludur.",
      "duplicate": "\xC7o\u011Falt\u0131ld\u0131 !",
      "duplicate_vcard": "\xC7o\u011Falt\u0131lan Vcard !",
      "duplicate_vcard_create": "\xC7o\u011Falt\u0131lan Vcard ba\u015Far\u0131yla olu\u015Fturuldu",
      "email": "E-posta",
      "email_required": "E-posta alan\u0131 gereklidir",
      "embedtag": "Etiketi yerle\u015Ftir",
      "enquiry": "Sorgu",
      "enter_valid_email": "L\xFCtfen ge\xE7erli bir e-posta adresi girin.",
      "enter_vcard_name": "L\xFCtfen bir Vcard Ad\u0131 girin",
      "error": "Hata",
      "faqs": "SSS",
      "feb": "\u015Eub",
      "first_name_required": "Ad alan\u0131 gereklidir.",
      "flat": "D\xFCz",
      "flutterwave_key": "Flutterwave anahtar alan\u0131 gereklidir.",
      "flutterwave_secret": "Flutterwave Gizli alan\u0131 gereklidir.",
      "fri": "CUM",
      "from": "Kimden",
      "front_image_field_required": "\xD6n resim alan\u0131 gereklidir",
      "gallery": "Galeri",
      "generate_url_alias": "L\xFCtfen bir URL Takma Ad\u0131 Olu\u015Fturun",
      "has_been_completed": "tamamland\u0131.",
      "has_been_deleted": "silindi.",
      "here_select_vcard_template": "Burada VCard \u015Eablonunuzu Se\xE7ebilirsiniz.",
      "image_too_large": "Dosyan\u0131z \xE7ok b\xFCy\xFCk. \u0130zin verilen maksimum boyut 1 MB't\u0131r.",
      "in_progress": "Devam ediyor",
      "inquries": "Sorgu",
      "invalid_country_code": "Ge\xE7ersiz \xFClke kodu",
      "invalid_email": "E-posta ge\xE7ersiz",
      "invalid_number": "Ge\xE7ersiz Numara",
      "jan": "Oca",
      "jul": "Tem",
      "jun": "Haz",
      "last_30_days": "Son 30 G\xFCn",
      "last_7_days": "Son 7 G\xFCn",
      "last_name_required": "Soyad\u0131 alan\u0131 gereklidir.",
      "last_week": "Ge\xE7en Hafta",
      "loading": "Y\xFCkleniyor...",
      "location_field_required": "Konum alan\u0131 gereklidir",
      "logo_field_required": "Kart logosu alan\u0131 gereklidir",
      "logo_image_error": "G\xF6r\xFCnt\xFC boyutlar\u0131 150x150 piksel veya daha k\xFC\xE7\xFCk olmal\u0131d\u0131r.",
      "manual_payment_guide": "Manuel \xD6deme Rehberi",
      "mar": "Mar",
      "may": "May",
      "mon": "PZT",
      "month": "Ay",
      "multi_templates": "\xC7oklu \u015Fablonlar gereklidir",
      "next": "Sonraki",
      "nfc_card": "NFC Kart\u0131",
      "nfc_order": "NFC Sipari\u015Fi",
      "no": "Hay\u0131r",
      "nov": "Kas",
      "occupation_field_required": "Meslek alan\u0131 gereklidir",
      "oct": "Eki",
      "ok": "Tamam",
      "onesignal_app_id": "OneSignal Uygulama Kimli\u011Fi alan\u0131 gereklidir.",
      "onesignal_rest_api_key": "OneSignal REST API Anahtar\u0131 alan\u0131 gereklidir.",
      "order_placed": "Sipari\u015Finiz ba\u015Far\u0131yla verildi!",
      "password_character": "\u015Eifre en az 8 karakter olmal\u0131d\u0131r.",
      "password_must_match": "\u015Eifre ve \u015Fifre onay\u0131 e\u015Fle\u015Fmelidir.",
      "passwords": "\u015Eifreler alan\u0131 gereklidir.",
      "payment_not_complete": "\xD6deme Tamamlanmad\u0131",
      "paypal_key": "Paypal M\xFC\u015Fteri Kimli\u011Fi alan\u0131 zorunludur.",
      "paypal_mode": "Paypal modu alan\u0131 gereklidir.",
      "paypal_secret": "Paypal gizli alan\u0131 gereklidir.",
      "paystack_key": "Paystack anahtar alan\u0131 gereklidir.",
      "paystack_secret": "Paystack Gizli alan\u0131 gereklidir.",
      "phone": "Telefon",
      "phone_number_required": "Telefon Numaras\u0131 alan\u0131 gereklidir.",
      "phonepe_env_required": "Phonepe Env alan\u0131 zorunlu.",
      "phonepe_merchant_id_required": "Phonepe t\xFCccar kimlik alan\u0131 zorunlu.",
      "phonepe_merchant_transaction_id_required": "Phonepe t\xFCccar i\u015Flem kimlik alan\u0131 zorunlu.",
      "phonepe_merchant_user_id_required": "Phonepe t\xFCccar kullan\u0131c\u0131 kimlik alan\u0131 zorunlu.",
      "phonepe_salt_index_required": "Phonepe Salt Index alan\u0131 zorunlu.",
      "phonepe_salt_key_required": "Phonepe Salt Key alan\u0131 zorunlu.",
      "plan": "Plan",
      "plan_expire_notification": "Plan Son Tarihi Bildirimi alan\u0131 gereklidir.",
      "please_select_user": "L\xFCtfen bir kullan\u0131c\u0131 se\xE7in",
      "please_wait": "L\xFCtfen bekleyin...",
      "privacy_policy": "Gizlilik Politikas\u0131",
      "product": "\xDCr\xFCn",
      "product_added_to_cart": "\xDCr\xFCn ba\u015Far\u0131yla sepetinize eklendi!",
      "product_category": "\xDCr\xFCn kategorisi",
      "product_deleted_from_cart": "\xDCr\xFCn ba\u015Far\u0131yla sepetinizden kald\u0131r\u0131ld\u0131!",
      "provide_valid_wbsite_url": "Ge\xE7erli bir URL girin",
      "purchase": "Sat\u0131n Alma",
      "razorpay_key": "Rozorpay anahtar alan\u0131 gereklidir.",
      "razorpay_secret": "Rozorpay Gizli alan\u0131 zorunludur.",
      "rejected": "Reddedildi",
      "remove": "Kald\u0131r",
      "sat": "CMT",
      "select_all": "T\xFCm\xFCn\xFC Se\xE7",
      "select_email_required": "Posta G\xF6nder alan\u0131 zorunludur.",
      "select_hour": "L\xFCtfen Tarih veya Saat Se\xE7in",
      "select_one_or_more": "Bir veya daha fazla \xF6zellik se\xE7mek zorunludur",
      "select_payment_type": "\xD6deme T\xFCr\xFCn\xFC Se\xE7in",
      "select_user": "Kullan\u0131c\u0131 se\xE7",
      "select_vcard": "\u0412\u044B\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0438\u0437\u0438\u0442\u043D\u0443\u044E \u043A\u0430\u0440\u0442\u043E\u0447\u043A\u0443",
      "send_email_description": "A\xE7\u0131klama",
      "sep": "Eyl",
      "short_description": "K\u0131sa A\xE7\u0131klama Girin",
      "skip": "Atlamak",
      "social_links_img_is_required": "Sosyal ba\u011Flant\u0131lar \u0130mgesi gereklidir.",
      "social_links_is_required": "Sosyal ba\u011Flant\u0131lar gereklidir.",
      "state": "Eyalet",
      "stripe_key": "Stripe anahtar alan\u0131 gereklidir.",
      "stripe_secret": "Stripe gizli alan\u0131 gereklidir.",
      "subject_required": "Konu alan\u0131 zorunludur.",
      "subscriptions": "Abonelikler",
      "successful": "Ba\u015Far\u0131l\u0131",
      "sun": "PAZ",
      "term_condition": "Kullan\u0131m \u015Eartlar\u0131",
      "testimonial": "Referans",
      "the_term_conditions": "Kullan\u0131m \u015Eartlar\u0131 zorunludur.",
      "this_is_analytics_chart": "Bu sizin VCard analiz Tablonuzdur.",
      "this_month": "Bu Ay",
      "this_week": "Bu Hafta",
      "thu": "PER",
      "to": "Kime",
      "today": "Bug\xFCn",
      "too_long": "\xC7ok uzun",
      "too_short": "\xC7ok k\u0131sa",
      "tue": "SAL",
      "unavailable": "Kullan\u0131lam\u0131yor",
      "upload_required": "Dosya y\xFCkleme alan\u0131 gereklidir.",
      "user": "Kullan\u0131c\u0131",
      "vcard": "VCard",
      "vcard_iframe": "VCard iframe",
      "vcard_name": "VCard Ad\u0131",
      "vcard_name_required": "Kart ad\u0131 alan\u0131 gereklidir",
      "vcard_service": "VCard Hizmeti",
      "vcard_testimonial": "VCard G\xF6r\xFC\u015F\xFC",
      "website_field_required": "Web sitesi alan\u0131 gereklidir",
      "wed": "\xC7AR",
      "whatsapp_store": "WhatsApp ma\u011Fazas\u0131",
      "yes": "Evet",
      "yesterday": "D\xFCn"
    },
    "vi.js": {
      "Yes_Change": "C\xF3, Ph\xEA duy\u1EC7t",
      "add_on": "Th\xEAm v\xE0o",
      "address_field": "Tr\u01B0\u1EDDng \u0111\u1ECBa ch\u1EC9 l\xE0 b\u1EAFt bu\u1ED9c.",
      "admin": "Qu\u1EA3n tr\u1ECB vi\xEAn",
      "affiliation_amount_error": "S\u1ED1 ti\u1EC1n li\xEAn k\u1EBFt kh\xF4ng th\u1EC3 v\u01B0\u1EE3t qu\xE1 100%",
      "affiliation_email_send": "Email m\u1EDDi \u0111\xE3 \u0111\u01B0\u1EE3c g\u1EEDi th\xE0nh c\xF4ng!",
      "agree_term": "B\u1EA1n ph\u1EA3i \u0111\u1ED3ng \xFD v\u1EDBi \u0110i\u1EC1u kho\u1EA3n v\xE0 \u0111i\u1EC1u ki\u1EC7n.",
      "allowed_file_types": "C\xE1c lo\u1EA1i t\u1EC7p \u0111\u01B0\u1EE3c ph\xE9p: png, jpg, jpeg.",
      "allowed_image": "C\xE1c lo\u1EA1i t\u1EC7p \u0111\u01B0\u1EE3c ph\xE9p: png, jpg, jpeg.",
      "amount": "S\u1ED1 ti\u1EC1n",
      "app_name_required": "Tr\u01B0\u1EDDng t\xEAn \u1EE9ng d\u1EE5ng l\xE0 b\u1EAFt bu\u1ED9c",
      "apply": "\xC1p d\u1EE5ng",
      "appointment": "Cu\u1ED9c h\u1EB9n",
      "appointments": "Cu\u1ED9c h\u1EB9n",
      "approved": "\u0110\u01B0\u1EE3c ph\xEA duy\u1EC7t",
      "apr": "Th4",
      "are_you_completed": "B\u1EA1n c\xF3 ch\u1EAFc ch\u1EAFn mu\u1ED1n ph\xEA duy\u1EC7t \u0111i\u1EC1u n\xE0y kh\xF4ng?",
      "are_you_sure": "B\u1EA1n c\xF3 ch\u1EAFc ch\u1EAFn mu\u1ED1n x\xF3a \u0111i\u1EC1u n\xE0y?",
      "are_you_sure_dublicate_vcard": "B\u1EA1n c\xF3 ch\u1EAFc ch\u1EAFn mu\u1ED1n t\u1EA1o b\u1EA3n sao VCard n\xE0y kh\xF4ng?",
      "aug": "Th8",
      "back_image_field_required": "Tr\u01B0\u1EDDng h\xECnh \u1EA3nh m\u1EB7t sau l\xE0 b\u1EAFt bu\u1ED9c",
      "blog": "Blog",
      "blog_description": "M\xF4 t\u1EA3",
      "blog_image_required": "Tr\u01B0\u1EDDng h\xECnh \u1EA3nh Blog l\xE0 b\u1EAFt bu\u1ED9c.",
      "cancel": "H\u1EE7y",
      "check_email": "Email \u0111\xE3 t\u1ED3n t\u1EA1i.",
      "choose_one_template": "Ch\u1ECDn m\u1ED9t m\u1EABu",
      "choose_plan": "Ch\u1ECDn k\u1EBF ho\u1EA1ch",
      "city": "Th\xE0nh ph\u1ED1",
      "click_open_sidebar": "Nh\u1EA5p v\xE0o Ti\u1EBFp theo \u0111\u1EC3 m\u1EDF Sidebar.",
      "click_to_add_vcard_name": "Nh\u1EA5p v\xE0o \u0111\xE2y \u0111\u1EC3 th\xEAm t\xEAn Vcard c\u1EE7a b\u1EA1n.",
      "click_to_create_vcards": "Nh\u1EA5p v\xE0o Ti\u1EBFp theo \u0111\u1EC3 t\u1EA1o VCard c\u1EE7a b\u1EA1n.",
      "click_to_generate_alias": "Nh\u1EA5p v\xE0o \u0111\xE2y \u0111\u1EC3 t\u1EA1o Alias URL c\u1EE7a b\u1EA1n.",
      "click_to_go_dashboard": "Nh\u1EA5p v\xE0o Ti\u1EBFp theo \u0111\u1EC3 ti\u1EBFp t\u1EE5c \u0111\u1EBFn B\u1EA3ng \u0111i\u1EC1u khi\u1EC3n.",
      "click_to_make_vcards": "Nh\u1EA5p v\xE0o Ti\u1EBFp theo \u0111\u1EC3 t\u1EA1o VCards m\u1EDBi.",
      "click_to_open_edit_sidebar": "Nh\u1EA5p v\xE0o Ti\u1EBFp theo \u0111\u1EC3 truy c\u1EADp Sidebar ch\u1EC9nh s\u1EEDa VCard.",
      "click_to_preview": "Nh\u1EA5p v\xE0o \u0111\xE2y \u0111\u1EC3 xem tr\u01B0\u1EDBc VCard c\u1EE7a b\u1EA1n.",
      "click_to_save_vcard": "Nh\u1EA5p v\xE0o Ti\u1EBFp theo \u0111\u1EC3 l\u01B0u VCard c\u1EE7a b\u1EA1n.",
      "completed": "Ho\xE0n th\xE0nh",
      "copied_successfully": "Li\xEAn k\u1EBFt \u0111\xE3 \u0111\u01B0\u1EE3c sao ch\xE9p th\xE0nh c\xF4ng.",
      "country": "Qu\u1ED1c gia",
      "coupon_code": "M\xE3 phi\u1EBFu gi\u1EA3m gi\xE1",
      "coupon_code_apply": "M\xE3 coupon \u0111\xE3 \u0111\u01B0\u1EE3c \xE1p d\u1EE5ng th\xE0nh c\xF4ng.",
      "coupon_code_percent_validation": "Gi\u1EA3m gi\xE1 m\xE3 coupon kh\xF4ng \u0111\u01B0\u1EE3c v\u01B0\u1EE3t qu\xE1 100%.",
      "custom": "T\xF9y ch\u1EC9nh",
      "custom_link": "Li\xEAn k\u1EBFt T\xF9y ch\u1EC9nh",
      "custom_vcard_number": "S\u1ED1 VCard t\xF9y ch\u1EC9nh",
      "custom_vcard_price": "Gi\xE1 VCard t\xF9y ch\u1EC9nh",
      "dec": "Th12",
      "delete": "X\xF3a",
      "deleted": "\u0110\xE3 x\xF3a",
      "description": "Nh\u1EADp m\xF4 t\u1EA3 VCard c\u1EE7a b\u1EA1n",
      "description_length": "M\xF4 t\u1EA3 ph\u1EA3i c\xF3 \xEDt nh\u1EA5t 3 k\xFD t\u1EF1.",
      "description_required": "Tr\u01B0\u1EDDng m\xF4 t\u1EA3 l\xE0 b\u1EAFt bu\u1ED9c.",
      "duplicate": "Tr\xF9ng l\u1EB7p!",
      "duplicate_vcard": "VCard tr\xF9ng l\u1EB7p!",
      "duplicate_vcard_create": "VCard tr\xF9ng l\u1EB7p \u0111\xE3 \u0111\u01B0\u1EE3c t\u1EA1o th\xE0nh c\xF4ng",
      "email": "Email",
      "email_required": "Tr\u01B0\u1EDDng email l\xE0 b\u1EAFt bu\u1ED9c.",
      "embedtag": "Th\u1EBB nh\xFAng",
      "enquiry": "Y\xEAu c\u1EA7u",
      "enter_valid_email": "Vui l\xF2ng nh\u1EADp email h\u1EE3p l\u1EC7.",
      "enter_vcard_name": "Vui l\xF2ng nh\u1EADp t\xEAn Vcard",
      "error": "L\u1ED7i",
      "faqs": "C\xE2u h\u1ECFi th\u01B0\u1EDDng g\u1EB7p",
      "feb": "Th2",
      "first_name_required": "Tr\u01B0\u1EDDng t\xEAn l\xE0 b\u1EAFt bu\u1ED9c.",
      "flat": "Gi\u1EA3m gi\xE1 c\u1ED1 \u0111\u1ECBnh",
      "flutterwave_key": "Tr\u01B0\u1EDDng kh\xF3a Flutterwave l\xE0 b\u1EAFt bu\u1ED9c.",
      "flutterwave_secret": "Tr\u01B0\u1EDDng b\xED m\u1EADt Flutterwave l\xE0 b\u1EAFt bu\u1ED9c.",
      "fri": "TH\u1EE8 S\xC1U",
      "from": "T\u1EEB",
      "front_image_field_required": "Tr\u01B0\u1EDDng h\xECnh \u1EA3nh m\u1EB7t tr\u01B0\u1EDBc l\xE0 b\u1EAFt bu\u1ED9c",
      "gallery": "Th\u01B0 vi\u1EC7n",
      "generate_url_alias": "Vui l\xF2ng t\u1EA1o Alias URL",
      "has_been_completed": "\u0111\xE3 \u0111\u01B0\u1EE3c ho\xE0n th\xE0nh.",
      "has_been_deleted": "\u0111\xE3 b\u1ECB x\xF3a.",
      "here_select_vcard_template": "\u1EDE \u0111\xE2y b\u1EA1n c\xF3 th\u1EC3 ch\u1ECDn m\u1EABu VCard c\u1EE7a m\xECnh.",
      "image_too_large": "T\u1EC7p c\u1EE7a b\u1EA1n qu\xE1 l\u1EDBn. K\xEDch th\u01B0\u1EDBc t\u1ED1i \u0111a cho ph\xE9p l\xE0 1MB.",
      "in_progress": "\u0110ang ti\u1EBFn h\xE0nh",
      "inquries": "Y\xEAu c\u1EA7u",
      "invalid_country_code": "M\xE3 qu\u1ED1c gia kh\xF4ng h\u1EE3p l\u1EC7",
      "invalid_email": "Email kh\xF4ng h\u1EE3p l\u1EC7",
      "invalid_number": "S\u1ED1 kh\xF4ng h\u1EE3p l\u1EC7",
      "jan": "Th1",
      "jul": "Th7",
      "jun": "Th6",
      "last_30_days": "30 ng\xE0y qua",
      "last_7_days": "7 ng\xE0y qua",
      "last_name_required": "Tr\u01B0\u1EDDng h\u1ECD l\xE0 b\u1EAFt bu\u1ED9c.",
      "last_week": "Tu\u1EA7n tr\u01B0\u1EDBc",
      "loading": "\u0110ang t\u1EA3i...",
      "location_field_required": "Tr\u01B0\u1EDDng \u0111\u1ECBa ch\u1EC9 l\xE0 b\u1EAFt bu\u1ED9c",
      "logo_field_required": "Tr\u01B0\u1EDDng logo E-Card l\xE0 b\u1EAFt bu\u1ED9c",
      "logo_image_error": "K\xEDch th\u01B0\u1EDBc h\xECnh \u1EA3nh ph\u1EA3i l\xE0 150x150 pixel ho\u1EB7c nh\u1ECF h\u01A1n.",
      "manual_payment_guide": "H\u01B0\u1EDBng d\u1EABn thanh to\xE1n th\u1EE7 c\xF4ng",
      "mar": "Th3",
      "may": "Th5",
      "mon": "Th\u1EE9 Hai",
      "month": "Th\xE1ng",
      "multi_templates": "C\u1EA7n \xEDt nh\u1EA5t m\u1ED9t m\u1EABu",
      "next": "Ti\u1EBFp theo",
      "nfc_card": "Th\u1EBB NFC",
      "nfc_order": "\u0110\u01A1n h\xE0ng NFC",
      "no": "Kh\xF4ng",
      "nov": "Th11",
      "occupation_field_required": "Tr\u01B0\u1EDDng ngh\u1EC1 nghi\u1EC7p l\xE0 b\u1EAFt bu\u1ED9c",
      "oct": "Th10",
      "ok": "\u0110\u1ED3ng \xFD",
      "onesignal_app_id": "Tr\u01B0\u1EDDng Onesignal App ID l\xE0 b\u1EAFt bu\u1ED9c.",
      "onesignal_rest_api_key": "Tr\u01B0\u1EDDng Onesignal Rest API Key l\xE0 b\u1EAFt bu\u1ED9c.",
      "order_placed": "\u0110\u01A1n h\xE0ng c\u1EE7a b\u1EA1n \u0111\xE3 \u0111\u01B0\u1EE3c \u0111\u1EB7t th\xE0nh c\xF4ng!",
      "password_character": "M\u1EADt kh\u1EA9u ph\u1EA3i c\xF3 \xEDt nh\u1EA5t 8 k\xFD t\u1EF1.",
      "password_must_match": "M\u1EADt kh\u1EA9u v\xE0 x\xE1c nh\u1EADn m\u1EADt kh\u1EA9u ph\u1EA3i kh\u1EDBp.",
      "passwords": "Tr\u01B0\u1EDDng m\u1EADt kh\u1EA9u l\xE0 b\u1EAFt bu\u1ED9c.",
      "payment_not_complete": "Thanh to\xE1n ch\u01B0a ho\xE0n t\u1EA5t",
      "paypal_key": "Tr\u01B0\u1EDDng Client ID Paypal l\xE0 b\u1EAFt bu\u1ED9c.",
      "paypal_mode": "Tr\u01B0\u1EDDng ch\u1EBF \u0111\u1ED9 Paypal l\xE0 b\u1EAFt bu\u1ED9c.",
      "paypal_secret": "Tr\u01B0\u1EDDng b\xED m\u1EADt Paypal l\xE0 b\u1EAFt bu\u1ED9c.",
      "paystack_key": "Tr\u01B0\u1EDDng kh\xF3a Paystack l\xE0 b\u1EAFt bu\u1ED9c.",
      "paystack_secret": "Tr\u01B0\u1EDDng b\xED m\u1EADt Paystack l\xE0 b\u1EAFt bu\u1ED9c.",
      "phone": "S\u1ED1 \u0111i\u1EC7n tho\u1EA1i",
      "phone_number_required": "Tr\u01B0\u1EDDng s\u1ED1 \u0111i\u1EC7n tho\u1EA1i l\xE0 b\u1EAFt bu\u1ED9c.",
      "phonepe_env_required": "Tr\u01B0\u1EDDng Phonepe Env l\xE0 b\u1EAFt bu\u1ED9c.",
      "phonepe_merchant_id_required": "Tr\u01B0\u1EDDng Phonepe Merchant ID l\xE0 b\u1EAFt bu\u1ED9c.",
      "phonepe_merchant_transaction_id_required": "Tr\u01B0\u1EDDng Phonepe Merchant Transaction ID l\xE0 b\u1EAFt bu\u1ED9c.",
      "phonepe_merchant_user_id_required": "Tr\u01B0\u1EDDng Phonepe Merchant User ID l\xE0 b\u1EAFt bu\u1ED9c.",
      "phonepe_salt_index_required": "Tr\u01B0\u1EDDng Phonepe Salt Index l\xE0 b\u1EAFt bu\u1ED9c.",
      "phonepe_salt_key_required": "Tr\u01B0\u1EDDng Phonepe Salt Key l\xE0 b\u1EAFt bu\u1ED9c.",
      "plan": "K\u1EBF ho\u1EA1ch",
      "plan_expire_notification": "Tr\u01B0\u1EDDng th\xF4ng b\xE1o h\u1EBFt h\u1EA1n k\u1EBF ho\u1EA1ch l\xE0 b\u1EAFt bu\u1ED9c.",
      "please_select_user": "Vui l\xF2ng ch\u1ECDn ng\u01B0\u1EDDi d\xF9ng",
      "please_wait": "Vui l\xF2ng \u0111\u1EE3i...",
      "privacy_policy": "Ch\xEDnh s\xE1ch b\u1EA3o m\u1EADt",
      "product": "S\u1EA3n ph\u1EA9m",
      "product_added_to_cart": "S\u1EA3n ph\u1EA9m \u0111\xE3 \u0111\u01B0\u1EE3c th\xEAm v\xE0o gi\u1ECF h\xE0ng c\u1EE7a b\u1EA1n th\xE0nh c\xF4ng!",
      "product_category": "Danh m\u1EE5c s\u1EA3n ph\u1EA9m",
      "product_deleted_from_cart": "S\u1EA3n ph\u1EA9m \u0111\xE3 \u0111\u01B0\u1EE3c x\xF3a kh\u1ECFi gi\u1ECF h\xE0ng c\u1EE7a b\u1EA1n th\xE0nh c\xF4ng!",
      "provide_valid_wbsite_url": "Vui l\xF2ng nh\u1EADp URL h\u1EE3p l\u1EC7",
      "purchase": "Mua",
      "razorpay_key": "Tr\u01B0\u1EDDng kh\xF3a Razorpay l\xE0 b\u1EAFt bu\u1ED9c.",
      "razorpay_secret": "Tr\u01B0\u1EDDng b\xED m\u1EADt Razorpay l\xE0 b\u1EAFt bu\u1ED9c.",
      "rejected": "B\u1ECB t\u1EEB ch\u1ED1i",
      "remove": "X\xF3a",
      "sat": "\u0110\xC3 NG\u1ED2I",
      "select_all": "Ch\u1ECDn t\u1EA5t c\u1EA3",
      "select_email_required": "Tr\u01B0\u1EDDng G\u1EEDi Mail l\xE0 b\u1EAFt bu\u1ED9c.",
      "select_hour": "Vui l\xF2ng ch\u1ECDn ng\xE0y ho\u1EB7c gi\u1EDD",
      "select_one_or_more": "Ch\u1ECDn m\u1ED9t ho\u1EB7c nhi\u1EC1u t\xEDnh n\u0103ng l\xE0 b\u1EAFt bu\u1ED9c",
      "select_payment_type": "Ch\u1ECDn Lo\u1EA1i thanh to\xE1n",
      "select_user": "Ch\u1ECDn Ng\u01B0\u1EDDi d\xF9ng",
      "select_vcard": "Ch\u1ECDn Vcard",
      "send_email_description": "M\xF4 t\u1EA3",
      "sep": "Th9",
      "short_description": "Nh\u1EADp m\xF4 t\u1EA3 ng\u1EAFn",
      "skip": "B\u1ECF qua",
      "social_links_img_is_required": "H\xECnh \u1EA3nh li\xEAn k\u1EBFt x\xE3 h\u1ED9i l\xE0 b\u1EAFt bu\u1ED9c.",
      "social_links_is_required": "Li\xEAn k\u1EBFt m\u1EA1ng x\xE3 h\u1ED9i l\xE0 b\u1EAFt bu\u1ED9c.",
      "state": "Ti\u1EC3u bang",
      "stripe_key": "Tr\u01B0\u1EDDng kh\xF3a Stripe l\xE0 b\u1EAFt bu\u1ED9c.",
      "stripe_secret": "Tr\u01B0\u1EDDng b\xED m\u1EADt Stripe l\xE0 b\u1EAFt bu\u1ED9c.",
      "subject_required": "Tr\u01B0\u1EDDng Ch\u1EE7 \u0111\u1EC1 l\xE0 b\u1EAFt bu\u1ED9c.",
      "subscriptions": "\u0110\u0103ng k\xFD",
      "successful": "Th\xE0nh c\xF4ng",
      "sun": "M\u1EB6T TR\u1EDCI",
      "term_condition": "\u0110i\u1EC1u kho\u1EA3n & \u0110i\u1EC1u ki\u1EC7n",
      "testimonial": "L\u1EDDi ch\u1EE9ng th\u1EF1c",
      "the_term_conditions": "\u0110i\u1EC1u kho\u1EA3n & \u0110i\u1EC1u ki\u1EC7n l\xE0 b\u1EAFt bu\u1ED9c.",
      "this_is_analytics_chart": "\u0110\xE2y l\xE0 Bi\u1EC3u \u0111\u1ED3 ph\xE2n t\xEDch VCard c\u1EE7a b\u1EA1n.",
      "this_month": "Th\xE1ng n\xE0y",
      "this_week": "Tu\u1EA7n n\xE0y",
      "thu": "THU",
      "to": "\u0110\u1EBFn",
      "today": "H\xF4m nay",
      "too_long": "Qu\xE1 d\xE0i",
      "too_short": "Qu\xE1 ng\u1EAFn",
      "tue": "TH\u1EE8 3",
      "unavailable": "Kh\xF4ng kh\u1EA3 d\u1EE5ng",
      "upload_required": "Tr\u01B0\u1EDDng t\u1EA3i l\xEAn t\u1EC7p l\xE0 b\u1EAFt bu\u1ED9c.",
      "user": "Ng\u01B0\u1EDDi d\xF9ng",
      "vcard": "VCard",
      "vcard_iframe": "VCard iframe",
      "vcard_name": "T\xEAn VCard",
      "vcard_name_required": "Tr\u01B0\u1EDDng t\xEAn Vcard l\xE0 b\u1EAFt bu\u1ED9c",
      "vcard_service": "D\u1ECBch v\u1EE5 VCard",
      "vcard_testimonial": "L\u1EDDi ch\u1EE9ng th\u1EF1c VCard",
      "website_field_required": "Tr\u01B0\u1EDDng website l\xE0 b\u1EAFt bu\u1ED9c",
      "wed": "Th\u1EE9 T\u01B0",
      "whatsapp_store": "C\u1EEDa h\xE0ng WhatsApp",
      "yes": "C\xF3",
      "yesterday": "H\xF4m qua"
    },
    "zh.js": {
      "Yes_Change": "\u662F\u7684\uFF0C\u6279\u51C6",
      "add_on": "\u9644\u52A0",
      "address_field": "\u5730\u5740\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "admin": "\u7BA1\u7406\u5458",
      "affiliation_amount_error": "\u96B6\u5C5E\u91D1\u989D\u4E0D\u80FD\u8D85\u8FC7100%",
      "affiliation_email_send": "\u9080\u8BF7\u90AE\u4EF6\u5DF2\u6210\u529F\u53D1\u9001\uFF01",
      "agree_term": "\u60A8\u5FC5\u987B\u540C\u610F\u6761\u6B3E\u548C\u6761\u4EF6\u3002",
      "allowed_file_types": "\u5141\u8BB8\u7684\u6587\u4EF6\u7C7B\u578B\uFF1Apng\uFF0Cjpg\uFF0Cjpeg\u3002",
      "allowed_image": "\u5141\u8BB8\u7684\u6587\u4EF6\u7C7B\u578B\uFF1Apng\uFF0Cjpg\uFF0Cjpeg\u3002",
      "amount": "\u6570\u91CF",
      "app_name_required": "\u5E94\u7528\u7A0B\u5E8F\u540D\u79F0\u5B57\u6BB5\u662F\u5FC5\u9700\u7684",
      "apply": "\u5E94\u7528",
      "appointment": "\u7EA6\u4F1A",
      "appointments": "\u7EA6\u4F1A",
      "approved": "\u5DF2\u6279\u51C6",
      "apr": "\u56DB\u6708",
      "are_you_completed": "\u60A8\u786E\u5B9A\u8981\u6279\u51C6\u5417\uFF1F",
      "are_you_sure": "\u60A8\u786E\u5B9A\u8981\u5220\u9664\u5417",
      "are_you_sure_dublicate_vcard": "\u60A8\u786E\u5B9A\u8981\u521B\u5EFA\u6B64VCard\u7684\u526F\u672C\u5417\uFF1F",
      "aug": "\u516B\u6708",
      "blog": "\u535A\u5BA2",
      "blog_description": "\u63CF\u8FF0",
      "blog_image_required": "\u90E8\u843D\u683C\u5716\u50CF\u6B04\u4F4D\u662F\u5FC5\u9700\u7684\u3002",
      "cancel": "\u53D6\u6D88",
      "check_email": "\u96FB\u5B50\u90F5\u4EF6\u5DF2\u7D93\u5B58\u5728\u3002",
      "choose_one_template": "\u9009\u62E9\u4EFB\u4F55\u4E00\u4E2A\u6A21\u677F",
      "choose_plan": "\u9009\u62E9\u8BA1\u5212",
      "city": "\u57CE\u5E02",
      "click_open_sidebar": "\u5355\u51FB\u201C\u4E0B\u4E00\u6B65\u201D\u6253\u5F00\u4FA7\u8FB9\u680F.",
      "click_to_create_vcards": "\u5355\u51FB\u201C\u4E0B\u4E00\u6B65\u201D\u521B\u5EFA\u60A8\u7684\u7535\u5B50\u540D\u7247.",
      "click_to_generate_alias": "\u5355\u51FB\u6B64\u5904\u751F\u6210\u60A8\u7684\u7F51\u5740\u522B\u540D.",
      "click_to_go_dashboard": "\u5355\u51FB\u201C\u4E0B\u4E00\u6B65\u201D\u8FDB\u5165\u4EEA\u8868\u677F.",
      "click_to_make_vcards": "\u5355\u51FB\u201C\u4E0B\u4E00\u6B65\u201D\u5236\u4F5C\u65B0\u7684\u7535\u5B50\u540D\u7247.",
      "click_to_open_edit_sidebar": "\u5355\u51FB\u201C\u4E0B\u4E00\u6B65\u201D\u8BBF\u95EE VCard \u7F16\u8F91\u4FA7\u680F.",
      "click_to_preview": "\u5355\u51FB\u6B64\u5904\u9884\u89C8\u60A8\u7684\u7535\u5B50\u540D\u7247",
      "click_to_save_vcard": "\u5355\u51FB\u201C\u4E0B\u4E00\u6B65\u201D\u4FDD\u5B58\u60A8\u7684\u7535\u5B50\u540D\u7247.",
      "completed": "\u5DF2\u5B8C\u6210",
      "copied_successfully": "\u94FE\u63A5\u5DF2\u6210\u529F\u590D\u5236\u3002",
      "country": "\u56FD\u5BB6",
      "coupon_code": "\u4F18\u60E0\u5238\u4EE3\u7801",
      "coupon_code_apply": "\u4F18\u60E0\u7801\u5DF2\u6210\u529F\u5E94\u7528.",
      "coupon_code_percent_validation": "\u4F18\u60E0\u5238\u6298\u6263\u4E0D\u5F97\u8D85\u8FC7100\uFF05\u3002",
      "custom": "\u81EA\u5B9A\u4E49",
      "custom_link": "\u81EA\u5B9A\u4E49\u94FE\u63A5",
      "dec": "\u5341\u4E8C\u6708",
      "delete": "\u5220\u9664",
      "deleted": "\u5DF2\u5220\u9664",
      "description": "\u8F93\u5165\u60A8\u7684VCard\u63CF\u8FF0",
      "description_length": "\u63CF\u8FF0\u5FC5\u987B\u81F3\u5C11\u5305\u542B3\u4E2A\u5B57\u7B26\u3002",
      "description_required": "\u63CF\u8FF0\u5B57\u6BB5\u662F\u5FC5\u586B\u9879.",
      "duplicate": "\u91CD\u590D\uFF01",
      "duplicate_vcard": "\u91CD\u590DVCard\uFF01",
      "duplicate_vcard_create": "\u6210\u529F\u521B\u5EFA\u91CD\u590DVCard",
      "email": "\u7535\u5B50\u90AE\u4EF6",
      "email_required": "\u7535\u5B50\u90AE\u4EF6\u5B57\u6BB5\u4E3A\u5FC5\u586B\u9879",
      "embedtag": "\u5D4C\u5165\u6807\u7B7E",
      "enquiry": "\u67E5\u8BE2",
      "enter_valid_email": "\u8BF7\u8F93\u5165\u6709\u6548\u7684\u7535\u5B50\u90AE\u4EF6\u3002",
      "enter_vcard_name": "\u8BF7\u8F93\u5165\u7535\u5B50\u540D\u7247\u540D\u79F0",
      "error": "\u9519\u8BEF",
      "faqs": "\u5E38\u89C1\u95EE\u9898",
      "feb": "\u4E8C\u6708",
      "first_name_required": "\u540D\u5B57\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "flat": "\u5E73",
      "flutterwave_key": "Flutterwave\u5BC6\u94A5\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "flutterwave_secret": "Flutterwave\u79D8\u5BC6\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "fri": "\u661F\u671F\u4E94",
      "from": "\u4ECE",
      "gallery": "\u753B\u5ECA",
      "generate_url_alias": "\u8BF7\u751F\u6210\u4E00\u4E2A URL \u522B\u540D",
      "has_been_completed": "\u5DF2\u5B8C\u6210\u3002",
      "has_been_deleted": "\u5DF2\u88AB\u5220\u9664\u3002",
      "here_select_vcard_template": "\u60A8\u53EF\u4EE5\u5728\u6B64\u5904\u9009\u62E9\u60A8\u7684\u7535\u5B50\u540D\u7247\u6A21\u677F.",
      "image_too_large": "\u60A8\u7684\u6587\u4EF6\u592A\u5927\u3002\u5141\u8A31\u7684\u6700\u5927\u5927\u5C0F\u70BA 1MB\u3002",
      "in_progress": "\u8FDB\u884C\u4E2D",
      "inquries": "\u8BE2\u95EE",
      "invalid_country_code": "\u65E0\u6548\u7684\u56FD\u5BB6\u4EE3\u7801",
      "invalid_email": "\u7535\u5B50\u90AE\u4EF6\u65E0\u6548",
      "invalid_number": "\u65E0\u6548\u53F7\u7801",
      "jan": "\u4E00\u6708",
      "jul": "\u4E03\u6708",
      "jun": "\u516D\u6708",
      "last_30_days": "\u6700\u8FD130\u5929",
      "last_7_days": "\u6700\u8FD17\u5929",
      "last_name_required": "\u59D3\u6C0F\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "last_week": "\u4E0A\u5468",
      "loading": "\u52A0\u8F7D\u4E2D...",
      "manual_payment_guide": "\u624B\u52A8\u652F\u4ED8\u6307\u5357",
      "mar": "\u4E09\u6708",
      "may": "\u4E94\u6708",
      "mon": "\u661F\u671F\u4E00",
      "month": "\u6708",
      "multi_templates": "\u9700\u8981\u591A\u4E2A\u6A21\u677F",
      "next": "\u4E0B\u4E00\u4E2A",
      "nfc_card": "NFC \u5361",
      "nfc_order": "NFC \u8BA2\u5355",
      "no": "\u4E0D",
      "nov": "\u5341\u4E00\u6708",
      "oct": "\u5341\u6708",
      "ok": "\u597D",
      "onesignal_app_id": "OneSignal \u5E94\u7528 ID \u5B57\u6BB5\u4E3A\u5FC5\u586B\u9879\u3002",
      "onesignal_rest_api_key": "OneSignal REST API \u5BC6\u94A5\u5B57\u6BB5\u4E3A\u5FC5\u586B\u9879\u3002",
      "order_placed": "\u60A8\u7684\u8BA2\u5355\u5DF2\u6210\u529F\u4E0B\u5355\uFF01",
      "password_character": "\u5BC6\u7801\u5FC5\u987B\u81F3\u5C11\u4E3A8\u4E2A\u5B57\u7B26\u3002",
      "password_must_match": "\u5BC6\u7801\u548C\u5BC6\u7801\u786E\u8BA4\u5FC5\u987B\u5339\u914D\u3002",
      "passwords": "\u5BC6\u7801\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "payment_not_complete": "\u652F\u4ED8\u672A\u5B8C\u6210",
      "paypal_key": "Paypal \u5BA2\u6237 ID \u5B57\u6BB5\u4E3A\u5FC5\u586B\u9879\u3002",
      "paypal_mode": "Paypal\u6A21\u5F0F\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "paypal_secret": "Paypal\u79D8\u5BC6\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "paystack_key": "Paystack\u5BC6\u94A5\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "paystack_secret": "Paystack\u79D8\u5BC6\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "phone": "\u7535\u8BDD",
      "phone_number_required": "\u7535\u8BDD\u53F7\u7801\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "phonepe_env_required": "Phonepe\u73AF\u5883\u5B57\u6BB5\u662F\u5FC5\u586B\u7684.",
      "phonepe_merchant_id_required": "Phonepe\u5546\u6237ID\u5B57\u6BB5\u662F\u5FC5\u586B\u7684.",
      "phonepe_merchant_transaction_id_required": "Phonepe\u5546\u6237\u4EA4\u6613ID\u5B57\u6BB5\u662F\u5FC5\u586B\u7684.",
      "phonepe_merchant_user_id_required": "Phonepe\u5546\u6237\u7528\u6237ID\u5B57\u6BB5\u662F\u5FC5\u586B\u7684.",
      "phonepe_salt_index_required": "Phonepe\u76D0\u503C\u7D22\u5F15\u5B57\u6BB5\u662F\u5FC5\u586B\u7684.",
      "phonepe_salt_key_required": "Phonepe\u76D0\u503C\u5BC6\u94A5\u5B57\u6BB5\u662F\u5FC5\u586B\u7684.",
      "plan": "\u8BA1\u5212",
      "plan_expire_notification": "\u8BA1\u5212\u5230\u671F\u901A\u77E5\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "please_select_user": "\u8BF7\u9009\u62E9\u4E00\u4E2A\u7528\u6237",
      "please_wait": "\u8BF7\u7A0D\u7B49...",
      "privacy_policy": "\u9690\u79C1\u653F\u7B56",
      "product": "\u4EA7\u54C1",
      "product_added_to_cart": "\u4EA7\u54C1\u5DF2\u6210\u529F\u6DFB\u52A0\u5230\u60A8\u7684\u8D2D\u7269\u8F66\uFF01",
      "product_category": "\u4EA7\u54C1\u7C7B\u522B",
      "product_deleted_from_cart": "\u4EA7\u54C1\u5DF2\u6210\u529F\u4ECE\u60A8\u7684\u8D2D\u7269\u8F66\u4E2D\u79FB\u9664\uFF01",
      "purchase": "\u8D2D\u4E70",
      "razorpay_key": "Rozorpay \u5173\u952E\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "razorpay_secret": "Rozorpay \u79D8\u5BC6\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "rejected": "\u5DF2\u62D2\u7EDD",
      "remove": "\u79FB\u9664",
      "sat": "\u661F\u671F\u516D",
      "select_all": "\u9009\u62E9\u5168\u90E8",
      "select_email_required": "\u53D1\u9001\u90AE\u4EF6\u5B57\u6BB5\u662F\u5FC5\u586B\u9879.",
      "select_hour": "\u8BF7\u9009\u62E9\u65E5\u671F\u6216\u5C0F\u65F6",
      "select_one_or_more": "\u9009\u62E9\u4E00\u4E2A\u6216\u591A\u4E2A\u529F\u80FD\u662F\u5FC5\u9700\u7684",
      "select_payment_type": "\u9009\u62E9\u4ED8\u6B3E\u65B9\u5F0F",
      "select_user": "\u9009\u62E9\u7528\u6237",
      "select_vcard": "\u9009\u62E9\u7535\u5B50\u540D\u7247",
      "send_email_description": "\u63CF\u8FF0",
      "sep": "\u4E5D\u6708",
      "short_description": "\u8BF7\u8F93\u5165\u7B80\u77ED\u63CF\u8FF0",
      "skip": "\u8DF3\u8FC7",
      "social_links_img_is_required": "\u793E\u4EA4\u94FE\u63A5\u56FE\u7247\u662F\u5FC5\u9700\u7684\u3002",
      "social_links_is_required": "\u793E\u4EA4\u94FE\u63A5\u662F\u5FC5\u9700\u7684\u3002",
      "state": "\u5DDE/\u7701",
      "stripe_key": "Stripe\u5BC6\u94A5\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "stripe_secret": "Stripe\u79D8\u5BC6\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "subject_required": "\u4E3B\u9898\u5B57\u6BB5\u662F\u5FC5\u586B\u9879.",
      "subscriptions": "\u8BA2\u9605",
      "successful": "\u6210\u529F",
      "sun": "\u661F\u671F\u65E5",
      "term_condition": "\u6761\u6B3E\u548C\u6761\u4EF6",
      "testimonial": "\u63A8\u8350",
      "the_term_conditions": "\u9700\u8981\u63A5\u53D7\u6761\u6B3E\u548C\u6761\u4EF6\u3002",
      "this_is_analytics_chart": "\u8FD9\u662F\u60A8\u7684 VCard \u5206\u6790\u56FE\u8868.",
      "this_month": "\u672C\u6708",
      "this_week": "\u672C\u5468",
      "thu": "\u661F\u671F\u56DB",
      "to": "\u5230",
      "today": "\u4ECA\u5929",
      "too_long": "\u592A\u957F",
      "too_short": "\u592A\u77ED",
      "tue": "\u661F\u671F\u4E8C",
      "unavailable": "\u4E0D\u53EF\u7528",
      "upload_required": "\u4E0A\u4F20\u6587\u4EF6\u5B57\u6BB5\u662F\u5FC5\u9700\u7684\u3002",
      "user": "\u7528\u6237",
      "vcard": "\u540D\u7247",
      "vcard_iframe": "V\u5361 iframe",
      "vcard_name": "VCard\u540D\u79F0",
      "vcard_service": "V\u5361\u670D\u52A1",
      "vcard_testimonial": "V\u5361\u63A8\u8350",
      "wed": "\u661F\u671F\u4E09",
      "whatsapp_store": "WhatsApp \u5546\u5E97",
      "yes": "\u662F",
      "yesterday": "\u6628\u5929"
    }
  });
})();

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./public/messages.js");
/******/ 	
/******/ })()
;